/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.fluid;

import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.init.BPModFluids;
import com.yungnickyoung.minecraft.betterportals.init.BPModItems;
import com.yungnickyoung.minecraft.betterportals.util.RGBAColor;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariants;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

@MethodsReturnNonnullByDefault
public abstract class PortalFluid
extends ForgeFlowingFluid {
    protected PortalFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid func_210197_e() {
        return BPModFluids.PORTAL_FLUID_FLOWING;
    }

    public Fluid func_210198_f() {
        return BPModFluids.PORTAL_FLUID;
    }

    public Item func_204524_b() {
        return BPModItems.PORTAL_BUCKET;
    }

    protected boolean func_205579_d() {
        return false;
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == BPModFluids.PORTAL_FLUID || fluidIn == BPModFluids.PORTAL_FLUID_FLOWING;
    }

    public boolean func_215665_a(FluidState fluidState, IBlockReader blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    protected void func_204522_a(World worldIn, BlockPos pos, FluidState state, Random random) {
        if (random.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, random.nextFloat() * 0.8f + 0.2f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        if (random.nextInt(3) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + (double)random.nextFloat(), (double)pos.func_177956_o() + (double)random.nextFloat(), (double)pos.func_177952_p() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public int func_205569_a(IWorldReader world) {
        return 35;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public IParticleData func_204521_c() {
        return ParticleTypes.field_239816_ap_;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
    }

    public int func_185698_b(IWorldReader world) {
        return 2;
    }

    public int func_204528_b(IWorldReader world) {
        return 2;
    }

    public BlockState func_204527_a(FluidState state) {
        return (BlockState)BPModBlocks.PORTAL_FLUID_BLOCK.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(PortalFluid.func_207205_e((FluidState)state)));
    }

    public static class PortalFluidAttributes
    extends FluidAttributes {
        private int currColor = -1;

        protected PortalFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public int getColor(IBlockDisplayReader world, BlockPos pos) {
            String dimensionName;
            try {
                dimensionName = Objects.requireNonNull(((ChunkRenderCache)world).field_212408_i.func_234923_W_().func_240901_a_()).toString();
            }
            catch (Exception e) {
                this.currColor = -65470432;
                return -65470432;
            }
            PortalLakeVariantSettings settings = PortalLakeVariants.get().getVariantForDimension(dimensionName);
            if (settings == null) {
                this.currColor = -65470432;
                return -65470432;
            }
            RGBAColor fluidColor = settings.getFluidColor();
            this.currColor = fluidColor.getColorValue();
            return fluidColor.getColorValue();
        }

        public int getColor(FluidStack stack) {
            return this.currColor;
        }

        public static FluidAttributes.Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            return new PortalBuilder(stillTexture, flowingTexture, PortalFluidAttributes::new);
        }

        public static class PortalBuilder
        extends FluidAttributes.Builder {
            protected PortalBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> factory) {
                super(stillTexture, flowingTexture, factory);
            }
        }
    }

    public static class Source
    extends PortalFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(@Nonnull FluidState state) {
            return 8;
        }

        public boolean func_207193_c(@Nonnull FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PortalFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(@Nonnull FluidState state) {
            return false;
        }
    }
}

