/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.init;

import com.yungnickyoung.minecraft.betterportals.init.BPModConfiguredFeatures;
import com.yungnickyoung.minecraft.betterportals.world.feature.MonolithFeature;
import com.yungnickyoung.minecraft.betterportals.world.feature.PortalLake2Feature;
import com.yungnickyoung.minecraft.betterportals.world.feature.PortalLakeFeature;
import java.util.function.Supplier;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BPModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"betterportals");
    public static final RegistryObject<Feature<NoFeatureConfig>> PORTAL_LAKE = BPModFeatures.register("portal_lake", PortalLakeFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> PORTAL_LAKE_2 = BPModFeatures.register("portal_lake_2", PortalLake2Feature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> MONOLITH = BPModFeatures.register("monolith", MonolithFeature::new);

    public static void init() {
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BPModFeatures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(BPModFeatures::onBiomeLoad);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(BPModConfiguredFeatures::registerConfiguredFeatures);
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().getFeatures(GenerationStage.Decoration.LAKES).add(() -> BPModConfiguredFeatures.CONFIGURED_PORTAL_LAKE);
        event.getGeneration().getFeatures(GenerationStage.Decoration.LAKES).add(() -> BPModConfiguredFeatures.CONFIGURED_PORTAL_LAKE_2);
        if (event.getName().toString().equals("minecraft:basalt_deltas")) {
            return;
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).add(() -> BPModConfiguredFeatures.CONFIGURED_MONOLITH);
    }

    private static <T extends Feature<?>> RegistryObject<T> register(String name, Supplier<T> feature) {
        return FEATURES.register(name, feature);
    }
}

