/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.item;

import com.yungnickyoung.minecraft.betterportals.BetterPortals;
import com.yungnickyoung.minecraft.betterportals.config.Configuration;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariants;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PortalBucketItem
extends BucketItem {
    public PortalBucketItem(Supplier<? extends Fluid> fluidSupplier, Item.Properties properties) {
        super(fluidSupplier, properties);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        String dimensionName;
        BlockRayTraceResult rayTraceResult = PortalBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        BlockPos targetPos = rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b());
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        try {
            dimensionName = Objects.requireNonNull(worldIn.func_234923_W_().func_240901_a_()).toString();
        }
        catch (Exception e) {
            BetterPortals.LOGGER.error("ERROR: Unable to get dimension name when using Plasma Bucket!");
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        PortalLakeVariantSettings settings = PortalLakeVariants.get().getVariantForDimension(dimensionName);
        if (settings == null) {
            worldIn.func_184133_a(playerIn, rayTraceResult.func_216350_a(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)targetPos.func_177958_n() + Math.random(), (double)targetPos.func_177956_o() + Math.random(), (double)targetPos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
            if (!worldIn.func_201670_d()) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("betterportals.portal_fluid_bucket.cannot_place_fluid").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), true);
            }
            return ActionResult.func_226251_d_((Object)itemStack);
        }
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.MISS && targetPos.func_177956_o() > (Integer)Configuration.maxPortalPlacementAltitude.get()) {
            if (!worldIn.func_201670_d()) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("betterportals.portal_fluid_bucket.altitude_error").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), true);
            }
            return ActionResult.func_226251_d_((Object)itemStack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

