/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.tileentity;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterportals.api.BetterPortalsCapabilities;
import com.yungnickyoung.minecraft.betterportals.api.IEntityPortalInfo;
import com.yungnickyoung.minecraft.betterportals.api.IPlayerPortalInfo;
import com.yungnickyoung.minecraft.betterportals.block.ReclaimerBlock;
import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.init.BPModTileEntities;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;

public class ReclaimerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private List<BeamPiece> beamSegments = Lists.newArrayList();
    private List<BeamPiece> tempBeamSegments = Lists.newArrayList();
    private int tempBeamMaxY = -1;
    private int beamMaxY;
    public int ticksExisted;
    private float activeRotation;

    public ReclaimerTileEntity() {
        super(BPModTileEntities.RECLAIMER_TILE_ENTITY);
    }

    public void func_73660_a() {
        int floatAmp;
        BlockPos currPos;
        boolean isPowered;
        ++this.ticksExisted;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.activeRotation += 1.0f;
        }
        if ((isPowered = this.isPowered()) && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_206939_L, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        int posX = this.field_174879_c.func_177958_n();
        int posY = this.field_174879_c.func_177956_o();
        int posZ = this.field_174879_c.func_177952_p();
        if (this.tempBeamMaxY < posY) {
            currPos = this.field_174879_c;
            this.tempBeamSegments = Lists.newArrayList();
            this.tempBeamMaxY = currPos.func_177956_o() - 1;
        } else {
            currPos = new BlockPos(posX, this.tempBeamMaxY + 1, posZ);
        }
        boolean hasHitBeamBlocker = false;
        BeamPiece beamSegment = this.tempBeamSegments.isEmpty() ? null : this.tempBeamSegments.get(this.tempBeamSegments.size() - 1);
        int surfaceHeight = this.field_145850_b.func_201676_a(Heightmap.Type.WORLD_SURFACE, posX, posZ);
        for (int i = 0; i < 10 && currPos.func_177956_o() <= surfaceHeight; ++i) {
            ArrayList beamBlockers;
            BlockState blockstate = this.field_145850_b.func_180495_p(currPos);
            float[] colors = blockstate.func_177230_c() == BPModBlocks.RECLAIMER_BLOCK ? ((ReclaimerBlock)blockstate.func_177230_c()).getColor(this.field_145850_b, this.isPowered()) : blockstate.getBeaconColorMultiplier((IWorldReader)this.field_145850_b, currPos, this.field_174879_c);
            String string = this.field_145850_b.func_234923_W_().func_240901_a_().toString();
            MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(string);
            ArrayList arrayList = beamBlockers = settings == null ? Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150343_Z.func_176223_P()}) : settings.getBeamStopBlocks();
            if (beamBlockers.contains(blockstate)) {
                hasHitBeamBlocker = true;
                break;
            }
            if (colors != null) {
                if (this.tempBeamSegments.size() <= 1) {
                    beamSegment = new BeamPiece(colors);
                    this.tempBeamSegments.add(beamSegment);
                } else if (beamSegment != null) {
                    if (Arrays.equals(colors, beamSegment.colors)) {
                        beamSegment.incrementHeight();
                    } else {
                        beamSegment = new BeamPiece(new float[]{(beamSegment.colors[0] + colors[0]) / 2.0f, (beamSegment.colors[1] + colors[1]) / 2.0f, (beamSegment.colors[2] + colors[2]) / 2.0f});
                        this.tempBeamSegments.add(beamSegment);
                    }
                }
            } else if (beamSegment != null) {
                beamSegment.incrementHeight();
            }
            currPos = currPos.func_177984_a();
            ++this.tempBeamMaxY;
        }
        if (this.tempBeamMaxY >= surfaceHeight || hasHitBeamBlocker) {
            if (!hasHitBeamBlocker) {
                this.tempBeamMaxY = 1024;
                this.tempBeamSegments.get(this.tempBeamSegments.size() - 1).setHeight(1024);
            }
            this.beamMaxY = this.tempBeamMaxY;
            this.tempBeamMaxY = -1;
            this.beamSegments = this.tempBeamSegments;
        }
        int n = floatAmp = isPowered ? 5 : 2;
        if (!this.field_145850_b.field_72995_K) {
            List<ItemEntity> itemsInBeam = this.getItemsInBeam();
            for (ItemEntity itemEntity : itemsInBeam) {
                double floatSpeed = isPowered ? 0.2 : 0.08;
                itemEntity.func_213293_j(itemEntity.func_213322_ci().func_82615_a() / 1.5, floatSpeed, itemEntity.func_213322_ci().func_82616_c() / 1.5);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            List<CreatureEntity> nonPlayersInBeam = this.getNonPlayersInBeam();
            for (CreatureEntity creatureEntity : nonPlayersInBeam) {
                creatureEntity.func_195064_c(new EffectInstance(Effects.field_188424_y, 2, floatAmp, false, false));
                if (!isPowered || creatureEntity.func_184218_aH() || creatureEntity.func_184207_aI() || !creatureEntity.func_184222_aU()) continue;
                creatureEntity.getCapability(BetterPortalsCapabilities.ENTITY_PORTAL_INFO).ifPresent(IEntityPortalInfo::enterReclaimer);
            }
        }
        List<PlayerEntity> playersInBeam = this.getPlayersInBeam();
        for (PlayerEntity playerEntity : playersInBeam) {
            if (!this.field_145850_b.field_72995_K && (!playerEntity.func_70644_a(Effects.field_188424_y) || playerEntity.func_70644_a(Effects.field_188424_y) && playerEntity.func_70660_b(Effects.field_188424_y).func_76459_b() <= 2)) {
                if (playerEntity.func_213453_ef()) {
                    playerEntity.func_195064_c(new EffectInstance(Effects.field_188424_y, 2, -5, false, false));
                } else {
                    playerEntity.func_195064_c(new EffectInstance(Effects.field_188424_y, 2, floatAmp, false, false));
                }
            }
            if (!isPowered) continue;
            playerEntity.getCapability(BetterPortalsCapabilities.PLAYER_PORTAL_INFO).ifPresent(IPlayerPortalInfo::enterReclaimer);
        }
    }

    private List<PlayerEntity> getPlayersInBeam() {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.beamMaxY, (double)(this.field_174879_c.func_177952_p() + 1));
        return this.field_145850_b.func_217357_a(PlayerEntity.class, axisAlignedBB);
    }

    private List<CreatureEntity> getNonPlayersInBeam() {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.beamMaxY, (double)(this.field_174879_c.func_177952_p() + 1));
        return this.field_145850_b.func_217357_a(CreatureEntity.class, axisAlignedBB);
    }

    private List<ItemEntity> getItemsInBeam() {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.beamMaxY, (double)(this.field_174879_c.func_177952_p() + 1));
        return this.field_145850_b.func_217357_a(ItemEntity.class, axisAlignedBB);
    }

    public void func_230337_a_(BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public List<BeamPiece> getBeamPieces() {
        return this.beamSegments;
    }

    public boolean isPowered() {
        BlockState state;
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == BPModBlocks.RECLAIMER_BLOCK && state.func_235901_b_((Property)ReclaimerBlock.POWERED)) {
            return (Boolean)state.func_177229_b((Property)ReclaimerBlock.POWERED);
        }
        return false;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public double func_145833_n() {
        return 256.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public float getActiveRotation(float partialTicks) {
        return (this.activeRotation + partialTicks) * (this.isPowered() ? -0.2f : -0.0375f);
    }

    public static class BeamPiece {
        private final float[] colors;
        private int height;

        public BeamPiece(float[] colorsIn) {
            this.colors = colorsIn;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        protected void setHeight(int height) {
            this.height = height;
        }

        public float[] getColors() {
            return this.colors;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

