/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.util;

import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class BlockUtil {
    public static void fill(ISeedReader world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }

    public static void replaceAir(ISeedReader world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        BlockPos.Mutable currPos = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    currPos.func_181079_c(x, y, z);
                    BlockState currBlock = world.func_180495_p((BlockPos)currPos);
                    if (currBlock != Blocks.field_150350_a.func_176223_P() && currBlock != Blocks.field_201941_jj.func_176223_P()) continue;
                    world.func_180501_a((BlockPos)currPos, blockState, 2);
                }
            }
        }
    }

    public static void replaceLiquid(ISeedReader world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        BlockPos.Mutable currPos = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    currPos.func_181079_c(x, y, z);
                    if (world.func_180495_p((BlockPos)currPos).func_204520_s().func_206886_c() == Fluids.field_204541_a) continue;
                    world.func_180501_a((BlockPos)currPos, blockState, 2);
                }
            }
        }
    }

    public static void replaceFallingBlock(ISeedReader world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        BlockPos.Mutable currPos = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    currPos.func_181079_c(x, y, z);
                    if (!(world.func_180495_p((BlockPos)currPos).func_177230_c() instanceof FallingBlock)) continue;
                    world.func_180501_a((BlockPos)currPos, blockState, 2);
                }
            }
        }
    }

    public static void fillRandom(ISeedReader world, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }

    public static void fill(ISeedReader world, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    world.func_180501_a(new BlockPos(x, y, z), selector.get(random), 2);
                }
            }
        }
    }

    public static void fillStairs(ISeedReader world, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector, Direction direction) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState = selector.get(random);
                    if (blockState.func_177230_c() instanceof StairsBlock) {
                        blockState = (BlockState)blockState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)direction);
                    }
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }

    public static void fillHorizontalBlock(ISeedReader world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState, Direction direction) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (blockState.func_177230_c() instanceof HorizontalBlock) {
                        blockState = (BlockState)blockState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction);
                    }
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }

    public static void fillWalls(ISeedReader world, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector, WallHeight north, WallHeight east, WallHeight south, WallHeight west, boolean up) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState = selector.get(random);
                    if (blockState.func_177230_c() instanceof WallBlock) {
                        blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)WallBlock.field_235613_c_, (Comparable)north)).func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)east)).func_206870_a((Property)WallBlock.field_235614_d_, (Comparable)south)).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)west)).func_206870_a((Property)WallBlock.field_176256_a, (Comparable)Boolean.valueOf(up));
                    }
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }

    public static void fillWallsRandom(ISeedReader world, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector, WallHeight north, WallHeight east, WallHeight south, WallHeight west, boolean up) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState = selector.get(random);
                    if (!(random.nextFloat() < chance) || !(blockState.func_177230_c() instanceof WallBlock)) continue;
                    blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a((Property)WallBlock.field_235613_c_, (Comparable)north)).func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)east)).func_206870_a((Property)WallBlock.field_235614_d_, (Comparable)south)).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)west)).func_206870_a((Property)WallBlock.field_176256_a, (Comparable)Boolean.valueOf(up));
                    world.func_180501_a(new BlockPos(x, y, z), blockState, 2);
                }
            }
        }
    }
}

