/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.util;

import com.yungnickyoung.minecraft.betterportals.BetterPortals;

public class RGBAColor {
    private String red;
    private String green;
    private String blue;
    private String alpha;

    public RGBAColor(String r, String g, String b, String a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    public String getRed() {
        return this.red;
    }

    public void setRed(String red) {
        this.red = red;
    }

    public String getGreen() {
        return this.green;
    }

    public void setGreen(String green) {
        this.green = green;
    }

    public String getBlue() {
        return this.blue;
    }

    public void setBlue(String blue) {
        this.blue = blue;
    }

    public String getAlpha() {
        return this.alpha;
    }

    public void setAlpha(String alpha) {
        this.alpha = alpha;
    }

    public int getColorValue() {
        String stringColor = (this.alpha + this.red + this.green + this.blue).toLowerCase();
        try {
            return (int)Long.parseLong(stringColor, 16);
        }
        catch (Exception e) {
            BetterPortals.LOGGER.error("Unable to parse color string {} as base 16 int. Using default color...", (Object)stringColor);
            return -1;
        }
    }

    public float[] getColorComponentValues() {
        int colorValue = this.getColorValue();
        int r = (colorValue & 0xFF0000) >> 16;
        int g = (colorValue & 0xFF00) >> 8;
        int b = colorValue & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

