/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.world;

import com.yungnickyoung.minecraft.betterportals.BetterPortals;
import com.yungnickyoung.minecraft.betterportals.api.IEntityPortalInfo;
import com.yungnickyoung.minecraft.betterportals.api.IPlayerPortalInfo;
import com.yungnickyoung.minecraft.betterportals.init.BPModFluids;
import com.yungnickyoung.minecraft.betterportals.init.BPModPOIs;
import com.yungnickyoung.minecraft.betterportals.util.BlockUtil;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariants;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;

public class ReclaimerTeleporter
implements ITeleporter {
    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld targetWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        WorldBorder worldborder = targetWorld.func_175723_af();
        double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        double scale = DimensionType.func_242715_a((DimensionType)entity.func_130014_f_().func_230315_m_(), (DimensionType)targetWorld.func_230315_m_());
        BlockPos.Mutable targetPos = new BlockPos.Mutable(MathHelper.func_151237_a((double)((double)((int)entity.func_226277_ct_()) * scale), (double)minX, (double)maxX), entity.func_226278_cu_(), MathHelper.func_151237_a((double)((double)((int)entity.func_226281_cx_()) * scale), (double)minZ, (double)maxZ));
        PointOfInterestManager pointofinterestmanager = targetWorld.func_217443_B();
        int blockSearchRange = 128;
        pointofinterestmanager.func_226347_a_((IWorldReader)targetWorld, (BlockPos)targetPos, blockSearchRange);
        Optional<BlockPos> optional = pointofinterestmanager.func_226353_b_(poiType -> poiType == BPModPOIs.PORTAL_LAKE_POI, (BlockPos)targetPos, blockSearchRange, PointOfInterestManager.Status.ANY).map(PointOfInterest::func_218261_f).filter(pos -> {
            Fluid fluid = targetWorld.func_180495_p(pos).func_204520_s().func_206886_c();
            return fluid == BPModFluids.PORTAL_FLUID_FLOWING || fluid == BPModFluids.PORTAL_FLUID;
        }).filter(pos -> {
            BlockState above = targetWorld.func_180495_p(pos.func_177984_a());
            return above.func_185904_a() == Material.field_151579_a || above.func_204520_s().func_206886_c() != Fluids.field_204541_a;
        }).min(Comparator.comparingDouble(pos -> this.xzDist((Vector3i)pos, (Vector3i)targetPos)));
        if (optional.isPresent()) {
            targetWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(optional.get()), 3, (Object)optional.get());
            return new PortalInfo(Vector3d.func_237491_b_((Vector3i)((Vector3i)optional.get())), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        }
        String sourceDimension = entity.func_130014_f_().func_234923_W_().func_240901_a_().toString();
        MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(sourceDimension);
        int targetMinY = settings.getPlayerTeleportedMinY();
        int targetMaxY = settings.getPlayerTeleportedMaxY();
        BlockState spawnPlatformBlock = Blocks.field_150347_e.func_176223_P();
        int targetY = -1;
        targetPos.func_185336_p(targetMaxY);
        boolean foundAir = false;
        int blocksSinceAir = 0;
        for (int y = targetMaxY; y >= targetMinY; --y) {
            BlockState blockState = targetWorld.func_180495_p((BlockPos)targetPos);
            if (blockState.func_185904_a() == Material.field_151579_a) {
                foundAir = true;
            } else if (blockState.func_185904_a().func_76220_a() && foundAir) {
                if (blocksSinceAir >= 2) {
                    targetY = y + 1;
                    break;
                }
                foundAir = false;
                blocksSinceAir = 0;
            }
            targetPos.func_189536_c(Direction.DOWN);
            if (!foundAir) continue;
            ++blocksSinceAir;
        }
        if (targetY == -1) {
            targetY = (targetMaxY + targetMinY) / 2;
            BlockUtil.replaceLiquid((ISeedReader)targetWorld, targetPos.func_177958_n() - 2, targetY - 1, targetPos.func_177952_p() - 2, targetPos.func_177958_n() + 2, targetY + 3, targetPos.func_177952_p() + 2, spawnPlatformBlock);
            BlockUtil.replaceFallingBlock((ISeedReader)targetWorld, targetPos.func_177958_n() - 2, targetY, targetPos.func_177952_p() - 2, targetPos.func_177958_n() + 2, targetY + 3, targetPos.func_177952_p() + 2, spawnPlatformBlock);
            BlockUtil.fill((ISeedReader)targetWorld, targetPos.func_177958_n() - 1, targetY, targetPos.func_177952_p() - 1, targetPos.func_177958_n() + 1, targetY + 2, targetPos.func_177952_p() + 1, Blocks.field_201941_jj.func_176223_P());
            BlockUtil.fill((ISeedReader)targetWorld, targetPos.func_177958_n() - 1, targetY - 1, targetPos.func_177952_p() - 1, targetPos.func_177958_n() + 1, targetY - 1, targetPos.func_177952_p() + 1, spawnPlatformBlock);
        }
        targetPos.func_185336_p(targetY);
        targetWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos((BlockPos)targetPos), 3, (Object)targetPos);
        Vector3d playerPos = new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p());
        playerPos = playerPos.func_72441_c(0.5, 0.0, 0.5);
        return new PortalInfo(playerPos, Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
    }

    public static void initTeleport(Entity entity, IPlayerPortalInfo playerPortalInfo) {
        if (entity.func_184218_aH() || entity.func_184207_aI() || !(entity instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity playerEntity = (ServerPlayerEntity)entity;
        String sourceDimension = playerEntity.field_70170_p.func_234923_W_().func_240901_a_().toString();
        MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(sourceDimension);
        if (settings == null) {
            BetterPortals.LOGGER.error("Unable to find reclaimer settings for dimension {}.", (Object)sourceDimension);
            BetterPortals.LOGGER.error("Have you removed the reclaimer variant for this dimension?");
            return;
        }
        String targetDimension = settings.getTargetDimension();
        MinecraftServer minecraftServer = playerEntity.func_184102_h();
        ServerWorld targetWorld = minecraftServer.func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(targetDimension)));
        if (targetWorld == null) {
            BetterPortals.LOGGER.error("Unable to enter dimension. You may have entered the dimension name {} incorrectly in your monoliths.json file.", (Object)targetDimension);
            BetterPortals.LOGGER.error("Alternatively, this could be due to a bug in vanilla Minecraft. Please restart the game to fix this.");
            return;
        }
        playerEntity.changeDimension(targetWorld, (ITeleporter)new ReclaimerTeleporter());
        playerPortalInfo.reset();
    }

    public static void teleportNonPlayer(Entity entity, IEntityPortalInfo entityPortalInfo) {
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        String sourceDimension = entity.field_70170_p.func_234923_W_().func_240901_a_().toString();
        MonolithVariantSettings settings = MonolithVariants.get().getVariantForDimension(sourceDimension);
        if (settings == null) {
            return;
        }
        String targetDimension = settings.getTargetDimension();
        MinecraftServer minecraftServer = entity.func_184102_h();
        ServerWorld targetWorld = minecraftServer.func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(targetDimension)));
        if (targetWorld == null) {
            BetterPortals.LOGGER.error("Unable to enter dimension. You may have entered the dimension name incorrectly: {}", (Object)targetDimension);
            BetterPortals.LOGGER.error("Alternatively, this could be due to a bug in vanilla Minecraft. Please restart the game to fix this.");
            return;
        }
        entityPortalInfo.reset();
        entity.changeDimension(targetWorld, (ITeleporter)new ReclaimerTeleporter());
    }

    private int xzDist(Vector3i pos1, Vector3i pos2) {
        int xDiff = pos1.func_177958_n() - pos2.func_177958_n();
        int zDiff = pos1.func_177952_p() - pos2.func_177952_p();
        return xDiff * xDiff + zDiff * zDiff;
    }
}

