/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.world.feature;

import com.yungnickyoung.minecraft.betterportals.BetterPortals;
import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.util.BlockUtil;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.MonolithVariants;
import java.util.Objects;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallHeight;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MonolithFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private MonolithVariantSettings settings;

    public MonolithFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        String dimensionName;
        try {
            dimensionName = Objects.requireNonNull(world.func_201672_e().func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterPortals.LOGGER.error("ERROR: Unable to get dimension name!");
            return false;
        }
        if (this.settings == null || !this.settings.getSpawnDimension().equals(dimensionName)) {
            this.settings = MonolithVariants.get().getVariantForDimension(dimensionName);
        }
        if (this.settings == null) {
            return false;
        }
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        sharedSeedRandom.func_202425_c(world.func_72905_C(), pos.func_177958_n() / 16, pos.func_177952_p() / 16);
        if ((double)sharedSeedRandom.nextFloat() > this.settings.getSpawnChance()) {
            return false;
        }
        if (pos.func_177956_o() < this.settings.getMinY() || pos.func_177956_o() > this.settings.getMaxY()) {
            return false;
        }
        int startX = pos.func_177958_n();
        int startZ = pos.func_177952_p();
        int startY = pos.func_177956_o();
        BlockPos.Mutable corner = new BlockPos.Mutable();
        int invalidCornerCounter = 0;
        for (int xCorner = 0; xCorner <= 1; ++xCorner) {
            for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                corner.func_181079_c(startX + xCorner * 8, startY - 1, startZ + zCorner * 8);
                if (world.func_180495_p((BlockPos)corner) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p((BlockPos)corner) == CAVE_AIR) {
                    return false;
                }
                if (world.func_180495_p((BlockPos)corner.func_189534_c(Direction.UP, 2)).func_196958_f() || world.func_180495_p((BlockPos)corner.func_189534_c(Direction.UP, 1)).func_196958_f() || ++invalidCornerCounter <= 1) continue;
                return false;
            }
        }
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY, startZ + 1, startX + 7, startY + 1, startZ + 7, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 2, startY, startZ + 1, startX + 6, startY, startZ + 1, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 2, startY, startZ + 7, startX + 6, startY, startZ + 7, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY, startZ + 2, startX + 1, startY, startZ + 6, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 7, startY, startZ + 2, startX + 7, startY, startZ + 6, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 2, startY, startZ, startX + 6, startY, startZ, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 2, startY, startZ + 8, startX + 6, startY, startZ + 8, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX, startY, startZ + 2, startX, startY, startZ + 6, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 8, startY, startZ + 2, startX + 8, startY, startZ + 6, this.settings.getInsideSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY, startZ + 1, startX + 1, startY + 1, startZ + 1, this.settings.getCornerSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 7, startY, startZ + 1, startX + 7, startY + 1, startZ + 1, this.settings.getCornerSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY, startZ + 7, startX + 1, startY + 1, startZ + 7, this.settings.getCornerSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 7, startY, startZ + 7, startX + 7, startY + 1, startZ + 7, this.settings.getCornerSelector());
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 3, startY, startZ, startX + 5, startY, startZ, this.settings.getStairSelector(), Direction.SOUTH);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX, startY, startZ + 3, startX, startY, startZ + 5, this.settings.getStairSelector(), Direction.EAST);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 8, startY, startZ + 3, startX + 8, startY, startZ + 5, this.settings.getStairSelector(), Direction.WEST);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 3, startY, startZ + 8, startX + 5, startY, startZ + 8, this.settings.getStairSelector(), Direction.NORTH);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 3, startY + 1, startZ + 1, startX + 5, startY + 1, startZ + 1, this.settings.getStairSelector(), Direction.SOUTH);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 1, startY + 1, startZ + 3, startX + 1, startY + 1, startZ + 5, this.settings.getStairSelector(), Direction.EAST);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 7, startY + 1, startZ + 3, startX + 7, startY + 1, startZ + 5, this.settings.getStairSelector(), Direction.WEST);
        BlockUtil.fillStairs(world, (Random)sharedSeedRandom, startX + 3, startY + 1, startZ + 7, startX + 5, startY + 1, startZ + 7, this.settings.getStairSelector(), Direction.NORTH);
        BlockUtil.fillHorizontalBlock(world, startX + 3, startY + 1, startZ + 3, startX + 3, startY + 1, startZ + 3, this.settings.getDecorationBlock(), Direction.NORTH);
        BlockUtil.fillHorizontalBlock(world, startX + 5, startY + 1, startZ + 3, startX + 5, startY + 1, startZ + 3, this.settings.getDecorationBlock(), Direction.EAST);
        BlockUtil.fillHorizontalBlock(world, startX + 3, startY + 1, startZ + 5, startX + 3, startY + 1, startZ + 5, this.settings.getDecorationBlock(), Direction.WEST);
        BlockUtil.fillHorizontalBlock(world, startX + 5, startY + 1, startZ + 5, startX + 5, startY + 1, startZ + 5, this.settings.getDecorationBlock(), Direction.SOUTH);
        BlockUtil.fill(world, startX + 4, startY + 1, startZ + 3, startX + 4, startY + 1, startZ + 3, this.settings.getPowerBlock());
        BlockUtil.fill(world, startX + 3, startY + 1, startZ + 4, startX + 3, startY + 1, startZ + 4, sharedSeedRandom.nextFloat() < 0.3f ? this.settings.getPowerBlock() : Blocks.field_150350_a.func_176223_P());
        BlockUtil.fill(world, startX + 5, startY + 1, startZ + 4, startX + 5, startY + 1, startZ + 4, sharedSeedRandom.nextFloat() < 0.3f ? this.settings.getPowerBlock() : Blocks.field_150350_a.func_176223_P());
        BlockUtil.fill(world, startX + 4, startY + 1, startZ + 5, startX + 4, startY + 1, startZ + 5, Blocks.field_150350_a.func_176223_P());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY + 2, startZ + 1, startX + 1, startY + 5, startZ + 1, this.settings.getFenceSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 7, startY + 2, startZ + 1, startX + 7, startY + 5, startZ + 1, this.settings.getFenceSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 1, startY + 2, startZ + 7, startX + 1, startY + 5, startZ + 7, this.settings.getFenceSelector());
        BlockUtil.fill(world, (Random)sharedSeedRandom, startX + 7, startY + 2, startZ + 7, startX + 7, startY + 5, startZ + 7, this.settings.getFenceSelector());
        BlockUtil.fillWalls(world, (Random)sharedSeedRandom, startX + 1, startY + 2, startZ + 1, startX + 1, startY + 2, startZ + 1, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.LOW, WallHeight.LOW, WallHeight.NONE, true);
        BlockUtil.fillWalls(world, (Random)sharedSeedRandom, startX + 7, startY + 2, startZ + 1, startX + 7, startY + 2, startZ + 1, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, WallHeight.LOW, true);
        BlockUtil.fillWalls(world, (Random)sharedSeedRandom, startX + 1, startY + 2, startZ + 7, startX + 1, startY + 2, startZ + 7, this.settings.getFenceSelector(), WallHeight.LOW, WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, true);
        BlockUtil.fillWalls(world, (Random)sharedSeedRandom, startX + 7, startY + 2, startZ + 7, startX + 7, startY + 2, startZ + 7, this.settings.getFenceSelector(), WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 2, startY + 2, startZ + 1, startX + 2, startY + 2, startZ + 1, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 6, startY + 2, startZ + 1, startX + 6, startY + 2, startZ + 1, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 1, startY + 2, startZ + 2, startX + 1, startY + 2, startZ + 2, this.settings.getFenceSelector(), WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, WallHeight.NONE, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 1, startY + 2, startZ + 6, startX + 1, startY + 2, startZ + 6, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, WallHeight.NONE, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 2, startY + 2, startZ + 7, startX + 2, startY + 2, startZ + 7, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 6, startY + 2, startZ + 7, startX + 6, startY + 2, startZ + 7, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 7, startY + 2, startZ + 2, startX + 7, startY + 2, startZ + 2, this.settings.getFenceSelector(), WallHeight.LOW, WallHeight.NONE, WallHeight.NONE, WallHeight.NONE, true);
        BlockUtil.fillWallsRandom(world, (Random)sharedSeedRandom, 0.6f, startX + 7, startY + 2, startZ + 6, startX + 7, startY + 2, startZ + 6, this.settings.getFenceSelector(), WallHeight.NONE, WallHeight.NONE, WallHeight.LOW, WallHeight.NONE, true);
        world.func_180501_a(new BlockPos(startX + 4, startY + 1, startZ + 4), BPModBlocks.RECLAIMER_BLOCK.func_176223_P(), 2);
        return true;
    }
}

