/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterportals.world.feature;

import com.yungnickyoung.minecraft.betterportals.BetterPortals;
import com.yungnickyoung.minecraft.betterportals.init.BPModBlocks;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariantSettings;
import com.yungnickyoung.minecraft.betterportals.world.variant.PortalLakeVariants;
import java.util.Objects;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PortalLake2Feature
extends Feature<NoFeatureConfig> {
    private PortalLakeVariantSettings settings;
    private static final BlockState AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState PORTAL_FLUID = BPModBlocks.PORTAL_FLUID_BLOCK.func_176223_P();

    public PortalLake2Feature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        int y;
        int x;
        String dimensionName;
        try {
            dimensionName = Objects.requireNonNull(world.func_201672_e().func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterPortals.LOGGER.error("ERROR: Unable to get dimension name!");
            return false;
        }
        if (this.settings == null || !this.settings.getSpawnDimension().equals(dimensionName)) {
            this.settings = PortalLakeVariants.get().getVariantForDimension(dimensionName);
        }
        if (this.settings == null) {
            return false;
        }
        if ((double)random.nextFloat() > this.settings.getSpawnChance() / 2.0) {
            return false;
        }
        BlockPos.Mutable mutable = pos.func_239590_i_();
        mutable.func_185336_p(this.settings.getMaxY() - this.settings.getMinY() + this.settings.getMinY() + 1);
        while (mutable.func_177956_o() > 5 && world.func_175623_d((BlockPos)mutable)) {
            mutable.func_189536_c(Direction.DOWN);
        }
        if (mutable.func_177956_o() <= 4) {
            return false;
        }
        mutable.func_189534_c(Direction.DOWN, 4);
        if (world.func_241827_a(SectionPos.func_218167_a((BlockPos)mutable), Structure.field_236381_q_).findAny().isPresent()) {
            return false;
        }
        boolean[] liquidMask = new boolean[2048];
        int i = random.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int x2 = 1; x2 < 15; ++x2) {
                for (int z = 1; z < 15; ++z) {
                    for (int y2 = 1; y2 < 7; ++y2) {
                        double d6 = ((double)x2 - d3) / (d0 / 2.0);
                        double d7 = ((double)y2 - d4) / (d1 / 2.0);
                        double d8 = ((double)z - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        liquidMask[(x2 * 16 + z) * 8 + y2] = true;
                    }
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 0; y < 8; ++y) {
                    boolean flag;
                    boolean bl = flag = !liquidMask[(x * 16 + z) * 8 + y] && (x < 15 && liquidMask[((x + 1) * 16 + z) * 8 + y] || x > 0 && liquidMask[((x - 1) * 16 + z) * 8 + y] || z < 15 && liquidMask[(x * 16 + z + 1) * 8 + y] || z > 0 && liquidMask[(x * 16 + (z - 1)) * 8 + y] || y < 7 && liquidMask[(x * 16 + z) * 8 + y + 1] || y > 0 && liquidMask[(x * 16 + z) * 8 + (y - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(mutable.func_177982_a(x, y, z)).func_185904_a();
                    if (y >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (y >= 4 || material.func_76220_a() || world.func_180495_p(mutable.func_177982_a(x, y, z)) == PORTAL_FLUID) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 0; y < 8; ++y) {
                    if (!liquidMask[(x * 16 + z) * 8 + y]) continue;
                    BlockPos newPos = mutable.func_177982_a(x, y, z);
                    world.func_180501_a(newPos, y >= 4 ? AIR : PORTAL_FLUID, 2);
                    world.func_205219_F_().func_205360_a(newPos, (Object)PORTAL_FLUID.func_204520_s().func_206886_c(), PORTAL_FLUID.func_204520_s().func_206886_c().func_205569_a((IWorldReader)world));
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 4; y < 8; ++y) {
                    BlockPos blockpos;
                    if (!liquidMask[(x * 16 + z) * 8 + y] || !PortalLake2Feature.func_227250_b_((Block)world.func_180495_p(blockpos = mutable.func_177982_a(x, y - 1, z)).func_177230_c()) || world.func_226658_a_(LightType.SKY, mutable.func_177982_a(x, y, z)) <= 0) continue;
                    Biome biome = world.func_226691_t_(blockpos);
                    if (biome.func_242440_e().func_242502_e().func_204108_a().func_203425_a(Blocks.field_150391_bh)) {
                        world.func_180501_a(blockpos, Blocks.field_150391_bh.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(blockpos, Blocks.field_196658_i.func_176223_P(), 2);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 0; y < 8; ++y) {
                    boolean flag1;
                    boolean bl = flag1 = !liquidMask[(x * 16 + z) * 8 + y] && (x < 15 && liquidMask[((x + 1) * 16 + z) * 8 + y] || x > 0 && liquidMask[((x - 1) * 16 + z) * 8 + y] || z < 15 && liquidMask[(x * 16 + z + 1) * 8 + y] || z > 0 && liquidMask[(x * 16 + (z - 1)) * 8 + y] || y < 7 && liquidMask[(x * 16 + z) * 8 + y + 1] || y > 0 && liquidMask[(x * 16 + z) * 8 + (y - 1)]);
                    if (!flag1 || y >= 4 && random.nextInt(2) == 0 || !world.func_180495_p(mutable.func_177982_a(x, y, z)).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(mutable.func_177982_a(x, y, z), this.settings.getBlockSelector().get(random), 2);
                }
            }
        }
        return true;
    }
}

