/*
 * Decompiled with CFR 0.152.
 */
package xyz.coolsa.biosphere;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import net.minecraft.class_5505;
import xyz.coolsa.biosphere.Biospheres;

public class BiospheresBiomeSource
extends class_1966 {
    public static final Codec<BiospheresBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(generator -> generator.registry), (App)Codec.LONG.fieldOf("seed").forGetter(generator -> generator.seed)).apply((Applicative)instance, instance.stable(BiospheresBiomeSource::new)));
    protected final long seed;
    protected final int sphereDistance;
    protected final int sphereRadius;
    protected final class_2919 chunkRandom;
    protected final class_2378<class_1959> registry;
    protected static final List<class_5321<class_1959>> BIOMES = ImmutableList.of((Object)class_1972.field_9451, (Object)class_1972.field_9409, (Object)class_1972.field_9415, (Object)class_1972.field_9434, (Object)class_1972.field_9417, (Object)class_1972.field_22077, (Object)class_1972.field_22075, (Object)class_1972.field_9462, (Object)class_1972.field_9424, (Object)class_1972.field_9475, (Object)class_1972.field_9452, (Object)class_1972.field_9440, (Object[])new class_5321[]{class_1972.field_23859, class_1972.field_9414, class_1972.field_9454, class_1972.field_9420, class_1972.field_9471, class_1972.field_9461, class_1972.field_9453});

    protected BiospheresBiomeSource(class_2378<class_1959> registry, long seed) {
        super((List)ImmutableList.of());
        this.seed = seed;
        this.sphereDistance = Biospheres.bsconfig.sphereRadius * 4;
        this.sphereRadius = Biospheres.bsconfig.sphereRadius;
        this.chunkRandom = new class_2919(seed);
        this.registry = registry;
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        if (this.getDistanceFromSphere(biomeX + 1, biomeZ + 1) < (double)(this.sphereRadius + 6)) {
            return (class_1959)this.registry.method_29107(this.getBiomeForSphere(biomeX, biomeZ));
        }
        return (class_1959)this.registry.method_29107(class_1972.field_9473);
    }

    public double getDistanceFromSphere(int biomeX, int biomeZ) {
        int centerX = (int)Math.round((double)(biomeX * 4) / (double)this.sphereDistance) * this.sphereDistance;
        int centerZ = (int)Math.round((double)(biomeZ * 4) / (double)this.sphereDistance) * this.sphereDistance;
        this.chunkRandom.method_12659(centerX, centerZ);
        class_2338 center = new class_2338(centerX, 0, centerZ);
        return Math.sqrt(center.method_10268((double)(biomeX * 4), 0.0, (double)(biomeZ * 4), true));
    }

    public class_5321<class_1959> getBiomeForSphere(int biomeX, int biomeZ) {
        int centerX = (int)Math.round((double)(biomeX * 4) / (double)this.sphereDistance) * this.sphereDistance;
        int centerZ = (int)Math.round((double)(biomeZ * 4) / (double)this.sphereDistance) * this.sphereDistance;
        this.chunkRandom.method_12659(centerX, centerZ);
        int randomChoice = this.chunkRandom.nextInt(BIOMES.size());
        return BIOMES.get(randomChoice);
    }

    public class_1966 method_27985(long seed) {
        return new BiospheresBiomeSource(this.registry, seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }
}

