/*
 * Decompiled with CFR 0.152.
 */
package xyz.coolsa.biosphere;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_3537;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5311;

public class BiospheresChunkGenerator
extends class_2794 {
    protected final long seed;
    protected final int sphereDistance;
    protected final int sphereRadius;
    protected final int oreSphereRadius;
    protected final int lakeRadius;
    protected final int shoreRadius;
    protected final class_1966 biomeSource;
    protected final class_2919 chunkRandom;
    protected final class_3537 noiseSampler;
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultNetherBlock;
    protected final class_2680 defaultFluid;
    protected final class_2680 defaultBridge;
    protected final class_2680 defaultEdge;
    protected final class_2680 defaultEdgeX;
    protected final class_2680 defaultEdgeZ;
    public static final Codec<BiospheresChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)Codec.LONG.fieldOf("seed").forGetter(generator -> generator.seed), (App)Codec.INT.fieldOf("sphere_distance").forGetter(generator -> generator.sphereDistance), (App)Codec.INT.fieldOf("sphere_radius").forGetter(generator -> generator.sphereRadius), (App)Codec.INT.fieldOf("lake_radius").forGetter(generator -> generator.lakeRadius), (App)Codec.INT.fieldOf("shore_radius").forGetter(generator -> generator.shoreRadius)).apply((Applicative)instance, instance.stable(BiospheresChunkGenerator::new)));

    public BiospheresChunkGenerator(class_1966 biomeSource, long seed, int sphereDistance, int sphereRadius, int lakeRadius, int shoreRadius) {
        super(biomeSource, new class_5311(false));
        this.biomeSource = biomeSource;
        this.seed = seed;
        this.sphereDistance = sphereRadius * 4;
        this.sphereRadius = sphereRadius;
        this.oreSphereRadius = 8;
        this.lakeRadius = lakeRadius;
        this.shoreRadius = shoreRadius;
        this.defaultBlock = class_2246.field_10340.method_9564();
        this.defaultNetherBlock = class_2246.field_10515.method_9564();
        this.defaultFluid = class_2246.field_10382.method_9564();
        this.defaultBridge = class_2246.field_10161.method_9564();
        this.defaultEdge = class_2246.field_10620.method_9564();
        this.defaultEdgeX = (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        this.defaultEdgeZ = (class_2680)((class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
        this.chunkRandom = new class_2919(this.seed);
        this.chunkRandom.method_12660(1000);
        this.noiseSampler = new class_3537(this.chunkRandom, IntStream.rangeClosed(-3, 0));
    }

    public void method_12110(class_3233 region, class_2791 chunk) {
        class_2338 centerPos = this.getNearestCenterSphere(chunk.method_12004().method_8323());
        class_2338.class_2339 current = new class_2338.class_2339();
        for (class_2338 pos : class_2338.method_10094((int)chunk.method_12004().method_8326(), (int)0, (int)chunk.method_12004().method_8328(), (int)chunk.method_12004().method_8327(), (int)0, (int)chunk.method_12004().method_8329())) {
            if (region.method_23753(centerPos).method_8688() == class_1959.class_1961.field_9366) {
                region.method_23753((class_2338)current.method_10101((class_2382)pos)).method_8703((Random)this.chunkRandom, chunk, pos.method_10263(), pos.method_10260(), centerPos.method_10264() * 4, 0.0625, this.defaultNetherBlock, this.defaultFluid, -10, this.seed);
                continue;
            }
            region.method_23753((class_2338)current.method_10101((class_2382)pos)).method_8703((Random)this.chunkRandom, chunk, pos.method_10263(), pos.method_10260(), centerPos.method_10264() * 4, 0.0625, this.defaultBlock, this.defaultFluid, -10, this.seed);
        }
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmapType) {
        return 0;
    }

    public class_1922 method_26261(int x, int z) {
        return null;
    }

    public void method_12088(class_1936 world, class_5138 accessor, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        class_2338.class_2339 current = new class_2338.class_2339();
        int xPos = chunkPos.method_8326();
        int zPos = chunkPos.method_8328();
        class_2338 centerPos = this.getNearestCenterSphere(chunkPos.method_8323());
        class_2338 oreCenterPos = this.getNearestOreSphere(chunkPos.method_8323());
        class_2680 fluidBlock = this.getLakeBlock(centerPos, chunk.method_12036().method_16359(chunkPos.field_9181, centerPos.method_10264(), chunkPos.field_9180));
        class_2902 oceanHeight = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 worldSurface = chunk.method_12032(class_2902.class_2903.field_13194);
        for (class_2338 pos : class_2338.method_10094((int)xPos, (int)0, (int)zPos, (int)(xPos + 15), (int)0, (int)(zPos + 15))) {
            current.method_10101((class_2382)pos);
            double radialDistance = Math.sqrt(pos.method_10268((double)centerPos.method_10263(), (double)pos.method_10264(), (double)centerPos.method_10260(), false));
            double oreRadialDistance = Math.sqrt(pos.method_10268((double)oreCenterPos.method_10263(), (double)pos.method_10264(), (double)oreCenterPos.method_10260(), false));
            if (radialDistance <= (double)this.sphereRadius) {
                double noise = this.noiseSampler.method_16454((double)pos.method_10263() / 8.0, (double)pos.method_10260() / 8.0, 0.0625, 0.0625) / 16.0;
                double sphereHeight = Math.sqrt(this.sphereRadius * this.sphereRadius - (centerPos.method_10263() - pos.method_10263()) * (centerPos.method_10263() - pos.method_10263()) - (pos.method_10260() - centerPos.method_10260()) * (pos.method_10260() - centerPos.method_10260()));
                int y = centerPos.method_10264() - (int)sphereHeight;
                while ((double)y <= sphereHeight + (double)centerPos.method_10264()) {
                    double lakeDistance = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)y, (double)pos.method_10260(), false));
                    double lakeDistance2d = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)centerPos.method_10264(), (double)pos.method_10260(), false));
                    double noiseTemp = noise + (double)(y / centerPos.method_10264());
                    class_2680 blockState = class_2246.field_10124.method_9564();
                    if ((double)y * noiseTemp < (double)centerPos.method_10264()) {
                        blockState = chunk.method_12036().method_16359(chunkPos.field_9181, centerPos.method_10264(), chunkPos.field_9180).method_8688() == class_1959.class_1961.field_9366 ? this.defaultNetherBlock : this.defaultBlock;
                    }
                    if ((blockState.equals(this.defaultBlock) || blockState.equals(this.defaultNetherBlock)) && lakeDistance2d <= (double)this.lakeRadius && !fluidBlock.equals(class_2246.field_10124.method_9564())) {
                        if (y >= centerPos.method_10264() && !fluidBlock.equals(class_2246.field_10340.method_9564())) {
                            blockState = class_2246.field_10124.method_9564();
                        } else if (lakeDistance <= (double)this.lakeRadius) {
                            blockState = fluidBlock;
                        }
                    }
                    chunk.method_12010((class_2338)current.method_10103(pos.method_10263(), y, pos.method_10260()), blockState, false);
                    oceanHeight.method_12597(pos.method_10263() & 0xF, y & 0xF, pos.method_10260() & 0xF, blockState);
                    worldSurface.method_12597(pos.method_10263() & 0xF, y & 0xF, pos.method_10260() & 0xF, blockState);
                    ++y;
                }
            }
            if (!(oreRadialDistance <= (double)this.oreSphereRadius)) continue;
        }
    }

    public class_2338 getNearestCenterSphere(class_2338 pos) {
        int xPos = pos.method_10263();
        int zPos = pos.method_10260();
        int centerX = (int)Math.round((double)xPos / (double)this.sphereDistance) * this.sphereDistance;
        int centerZ = (int)Math.round((double)zPos / (double)this.sphereDistance) * this.sphereDistance;
        this.chunkRandom.method_12659(centerX, centerZ);
        int centerY = (int)((Math.pow((double)this.chunkRandom.nextFloat() % 1.0 - 0.5, 3.0) + 0.5) * (double)(this.sphereRadius * 2 - this.sphereRadius * 4)) + this.sphereRadius * 2;
        return new class_2338(centerX, centerY, centerZ);
    }

    public class_2338 getNearestOreSphere(class_2338 pos) {
        int xPos = pos.method_10263();
        int zPos = pos.method_10260();
        int centerX = (int)Math.round((double)xPos / (double)this.sphereDistance - 0.5) * this.sphereDistance;
        int centerZ = (int)Math.round((double)zPos / (double)this.sphereDistance - 0.5) * this.sphereDistance;
        this.chunkRandom.method_12659(centerX, centerZ);
        int centerY = this.chunkRandom.nextInt(256 - this.oreSphereRadius * 4) + this.oreSphereRadius * 2;
        return new class_2338(centerX + this.sphereDistance / 2, centerY, centerZ + this.sphereDistance / 2);
    }

    public class_2680 getLakeBlock(class_2338 center, class_1959 biome) {
        this.chunkRandom.method_12659(center.method_10263(), center.method_10260());
        int rng = this.chunkRandom.nextInt(10);
        class_2680 state = biome.method_8688() == class_1959.class_1961.field_9366 ? class_2246.field_10515.method_9564() : class_2246.field_10340.method_9564();
        if (rng >= 1 && rng <= 8) {
            state = this.defaultFluid;
        } else if (rng == 9) {
            state = class_2246.field_10164.method_9564();
        }
        return state;
    }

    public class_2794 method_27997(long seed) {
        return new BiospheresChunkGenerator(this.biomeSource.method_27985(seed), seed, this.sphereRadius * 4, this.sphereRadius, this.lakeRadius, this.shoreRadius);
    }

    public void method_12108(long seed, class_4543 access, class_2791 chunk, class_2893.class_2894 carver) {
    }

    public void method_12102(class_3233 region, class_5138 accessor) {
        class_2338 chunkCenter = new class_2338(region.method_14336() * 16, 0, region.method_14339() * 16);
        class_1959 biome = this.biomeSource.method_16359(chunkCenter.method_10263() / 4 + 2, 2, chunkCenter.method_10260() / 4 + 2);
        super.method_12102(region, accessor);
        this.finishBiospheres(region);
    }

    public class_2338[] getClosestSpheres(class_2338 centerPos) {
        class_2338[] nesw = new class_2338[4];
        for (int i = 0; i < 4; ++i) {
            int xMod = centerPos.method_10263();
            int zMod = centerPos.method_10260();
            if (i / 2 < 1) {
                xMod += (int)Math.round(Math.pow(-1.0, i) * (double)this.sphereDistance);
            } else {
                zMod += (int)Math.round(Math.pow(-1.0, i) * (double)this.sphereDistance);
            }
            nesw[i] = this.getNearestCenterSphere(new class_2338(xMod, 0, zMod));
        }
        return nesw;
    }

    public void finishBiospheres(class_3233 region) {
        class_2338 chunkCenter = new class_2338(region.method_14336() * 16, 0, region.method_14339() * 16);
        class_2338.class_2339 current = new class_2338.class_2339();
        class_2338 centerPos = this.getNearestCenterSphere(chunkCenter);
        for (class_2338 pos : class_2338.method_10094((int)(chunkCenter.method_10263() - 7), (int)0, (int)(chunkCenter.method_10260() - 7), (int)(chunkCenter.method_10263() + 8), (int)0, (int)(chunkCenter.method_10260() + 8))) {
            current.method_10101((class_2382)pos);
            double radialDistance = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)centerPos.method_10264(), (double)pos.method_10260(), false));
            double noise = this.noiseSampler.method_16454((double)pos.method_10263() / 8.0, (double)pos.method_10260() / 8.0, 0.0625, 0.0625) / 8.0;
            double sphereHeight = Math.sqrt(this.sphereRadius * this.sphereRadius - (centerPos.method_10263() - pos.method_10263()) * (centerPos.method_10263() - pos.method_10263()) - (pos.method_10260() - centerPos.method_10260()) * (pos.method_10260() - centerPos.method_10260()));
            if (radialDistance <= (double)(this.sphereRadius + 16)) {
                int y = centerPos.method_10264() - (int)sphereHeight;
                while ((double)y <= sphereHeight + (double)centerPos.method_10264()) {
                    double newRadialDistance = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)y, (double)pos.method_10260(), false));
                    double noiseTemp = noise + (double)(y / centerPos.method_10264());
                    class_2680 blockState = class_2246.field_10124.method_9564();
                    if (!(newRadialDistance <= (double)(this.sphereRadius - 1))) {
                        if ((double)y * noiseTemp >= (double)centerPos.method_10264()) {
                            blockState = class_2246.field_10033.method_9564();
                        } else {
                            if (region.method_23753(chunkCenter).method_8688() == class_1959.class_1961.field_9366) {
                                blockState = this.defaultNetherBlock;
                            }
                            blockState = this.defaultBlock;
                        }
                        region.method_8652((class_2338)current.method_10103(pos.method_10263(), y, pos.method_10260()), blockState, 0);
                    }
                    ++y;
                }
                double largerSphereHeight = Math.sqrt((this.sphereRadius + 16) * (this.sphereRadius + 16) - (centerPos.method_10263() - pos.method_10263()) * (centerPos.method_10263() - pos.method_10263()) - (pos.method_10260() - centerPos.method_10260()) * (pos.method_10260() - centerPos.method_10260()));
                int y2 = 0;
                while ((double)y2 <= largerSphereHeight + (double)centerPos.method_10264()) {
                    double newRadialDistance = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)y2, (double)pos.method_10260(), false));
                    if (newRadialDistance >= (double)this.sphereRadius) {
                        region.method_8652((class_2338)current.method_10103(pos.method_10263(), y2, pos.method_10260()), class_2246.field_10124.method_9564(), 0);
                    }
                    ++y2;
                }
            }
            this.makeBridges(pos, centerPos, this.getClosestSpheres(centerPos), region, current);
        }
    }

    public void makeBridges(class_2338 pos, class_2338 centerPos, class_2338[] nesw, class_3233 region, class_2338.class_2339 current) {
        double radialDistance = Math.sqrt(centerPos.method_10268((double)pos.method_10263(), (double)centerPos.method_10264(), (double)pos.method_10260(), false));
        block6: for (int i = 0; i < 4; ++i) {
            if (!(radialDistance > (double)(this.sphereRadius - 2))) continue;
            double slope = nesw[i].method_10264() - centerPos.method_10264();
            double currentPos = 0.0;
            switch (i) {
                case 0: {
                    slope /= Math.abs((double)(centerPos.method_10260() - nesw[i].method_10260())) - (double)(2 * this.sphereRadius);
                    currentPos = centerPos.method_10263() - pos.method_10263() + this.sphereRadius;
                    if (pos.method_10260() > centerPos.method_10260() + 2 || pos.method_10260() < centerPos.method_10260() - 2 || pos.method_10263() <= centerPos.method_10263()) continue block6;
                    this.fillBridgeSlice(new class_2338((double)pos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)pos.method_10260()), new class_2338((double)centerPos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)centerPos.method_10260()), region, current, true);
                    continue block6;
                }
                case 1: {
                    slope /= -Math.abs((double)(centerPos.method_10260() - nesw[i].method_10260())) + (double)(2 * this.sphereRadius);
                    currentPos = centerPos.method_10263() - pos.method_10263() - this.sphereRadius;
                    if (pos.method_10260() > centerPos.method_10260() + 2 || pos.method_10260() < centerPos.method_10260() - 2 || pos.method_10263() >= centerPos.method_10263()) continue block6;
                    this.fillBridgeSlice(new class_2338((double)pos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)pos.method_10260()), new class_2338((double)centerPos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)centerPos.method_10260()), region, current, true);
                    continue block6;
                }
                case 2: {
                    slope /= -Math.abs((double)(centerPos.method_10260() - nesw[i].method_10260())) + (double)(2 * this.sphereRadius);
                    currentPos = centerPos.method_10260() - pos.method_10260() + this.sphereRadius;
                    if (pos.method_10263() > centerPos.method_10263() + 2 || pos.method_10263() < centerPos.method_10263() - 2 || pos.method_10260() <= centerPos.method_10260()) continue block6;
                    this.fillBridgeSlice(new class_2338((double)pos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)pos.method_10260()), new class_2338((double)centerPos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)centerPos.method_10260()), region, current, false);
                    continue block6;
                }
                case 3: {
                    slope /= Math.abs((double)(centerPos.method_10260() - nesw[i].method_10260())) - (double)(2 * this.sphereRadius);
                    currentPos = centerPos.method_10260() - pos.method_10260() - this.sphereRadius;
                    if (pos.method_10263() > centerPos.method_10263() + 2 || pos.method_10263() < centerPos.method_10263() - 2 || pos.method_10260() >= centerPos.method_10260()) continue block6;
                    this.fillBridgeSlice(new class_2338((double)pos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)pos.method_10260()), new class_2338((double)centerPos.method_10263(), slope * currentPos + (double)centerPos.method_10264(), (double)centerPos.method_10260()), region, current, false);
                }
            }
        }
    }

    public void fillBridgeSlice(class_2338 pos, class_2338 centerPos, class_3233 region, class_2338.class_2339 current, boolean xa) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int cx = centerPos.method_10263();
        int cz = centerPos.method_10260();
        region.method_8652((class_2338)current.method_10103(x, y - 1, z), this.defaultBridge, 0);
        region.method_8652((class_2338)current.method_10103(x, y, z), class_2246.field_10124.method_9564(), 0);
        if (xa) {
            region.method_8652((class_2338)current.method_10103(x, y, cz + 2), this.defaultEdgeX, 0);
            region.method_8652((class_2338)current.method_10103(x, y, cz - 2), this.defaultEdgeX, 0);
        } else {
            region.method_8652((class_2338)current.method_10103(cx + 2, y, z), this.defaultEdgeZ, 0);
            region.method_8652((class_2338)current.method_10103(cx - 2, y, z), this.defaultEdgeZ, 0);
        }
        region.method_8652((class_2338)current.method_10103(x, y + 1, z), class_2246.field_10124.method_9564(), 0);
        region.method_8652((class_2338)current.method_10103(x, y + 2, z), class_2246.field_10124.method_9564(), 0);
        region.method_8652((class_2338)current.method_10103(x, y + 3, z), class_2246.field_10124.method_9564(), 0);
    }

    public void fillBridgeEdge(class_2338 pos, class_3233 region, class_2338.class_2339 current, boolean xa) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }
}

