/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities;

import com.google.common.collect.Lists;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphList;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.MorphAddedSynchronizer;
import de.budschie.bmorph.network.MorphCapabilityFullSynchronizer;
import de.budschie.bmorph.network.MorphChangedSynchronizer;
import de.budschie.bmorph.network.MorphRemovedSynchronizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.fml.network.PacketDistributor;

public class DefaultMorphCapability
implements IMorphCapability {
    int aggroTimestamp = 0;
    int aggroDuration = 0;
    Optional<MorphItem> morph = Optional.empty();
    Optional<Integer> currentMorphIndex = Optional.empty();
    MorphList morphList = new MorphList();
    List<Ability> currentAbilities;
    private boolean dirty = true;

    @Override
    public void syncWithClients(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.serializeAbilities(), player.func_110124_au()));
    }

    @Override
    public void syncWithClient(PlayerEntity player, ServerPlayerEntity syncTo) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> syncTo), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.serializeAbilities(), player.func_110124_au()));
    }

    @Override
    public void syncWithConnection(PlayerEntity player, NetworkManager connection) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.NMLIST.with(() -> Lists.newArrayList((Object[])new NetworkManager[]{connection})), (Object)new MorphCapabilityFullSynchronizer.MorphPacket(this.morph, this.currentMorphIndex, this.morphList, this.serializeAbilities(), player.func_110124_au()));
    }

    @Override
    public void syncMorphChange(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MorphChangedSynchronizer.MorphChangedPacket(player.func_110124_au(), this.currentMorphIndex, this.morph, this.serializeAbilities()));
    }

    @Override
    public void syncMorphAcquisition(PlayerEntity player, MorphItem item) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MorphAddedSynchronizer.MorphAddedPacket(player.func_110124_au(), item));
    }

    @Override
    public void syncMorphRemoval(PlayerEntity player, int index) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalAccessError("This method may not be called on client side.");
        }
        MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MorphRemovedSynchronizer.MorphRemovedPacket(player.func_110124_au(), index));
    }

    private ArrayList<String> serializeAbilities() {
        if (this.getCurrentAbilities() == null || this.getCurrentAbilities().size() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> toString = new ArrayList<String>();
        for (Ability ability : this.getCurrentAbilities()) {
            toString.add(ability.getRegistryName().toString());
        }
        return toString;
    }

    @Override
    public void addToMorphList(MorphItem morphItem) {
        this.dirty = true;
        this.morphList.addToMorphList(morphItem);
    }

    @Override
    public void removeFromMorphList(int index) {
        this.dirty = true;
        this.morphList.removeFromMorphList(index);
    }

    @Override
    public void setMorphList(MorphList list) {
        this.dirty = true;
        this.morphList = list;
    }

    @Override
    public MorphList getMorphList() {
        return this.morphList;
    }

    @Override
    public void applyHealthOnPlayer(PlayerEntity player) {
        float playerHealthPercentage = player.func_110143_aJ() / player.func_110138_aP();
        if (!this.getCurrentMorph().isPresent()) {
            player.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            player.func_70606_j((float)Math.floor(20.0f * playerHealthPercentage));
        } else {
            Entity thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode = this.getCurrentMorph().get().createEntity(player.field_70170_p);
            if (thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode instanceof LivingEntity) {
                float maxHealthOfEntity = ((LivingEntity)thisisnotveryperformantoranythinglikethisbutidontcarealsothisnameisverystupidsoidkmaybeishouldhchangethislaterbutontheotherhandthisisalsobtwyouhavejustfoundaneasteregginmycode).func_110138_aP();
                player.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)maxHealthOfEntity);
                player.func_70606_j(Math.max((float)Math.floor(maxHealthOfEntity * playerHealthPercentage), 0.1f));
            } else {
                player.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
                player.func_70606_j((float)Math.floor(20.0f * playerHealthPercentage));
            }
        }
    }

    @Override
    public Optional<Integer> getCurrentMorphIndex() {
        return this.currentMorphIndex;
    }

    @Override
    public Optional<MorphItem> getCurrentMorphItem() {
        return this.morph;
    }

    @Override
    public Optional<MorphItem> getCurrentMorph() {
        if (this.currentMorphIndex.isPresent()) {
            return Optional.of(this.getMorphList().getMorphArrayList().get(this.currentMorphIndex.get()));
        }
        if (this.morph.isPresent()) {
            return this.morph;
        }
        return Optional.empty();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void cleanDirty() {
        this.dirty = false;
    }

    @Override
    public void setMorph(int index) {
        this.morph = Optional.empty();
        this.currentMorphIndex = Optional.of(index);
        this.dirty = true;
    }

    @Override
    public void setMorph(MorphItem morph) {
        this.morph = Optional.of(morph);
        this.currentMorphIndex = Optional.empty();
        this.dirty = true;
    }

    @Override
    public void demorph() {
        this.morph = Optional.empty();
        this.currentMorphIndex = Optional.empty();
        this.dirty = true;
    }

    @Override
    public List<Ability> getCurrentAbilities() {
        return this.currentAbilities;
    }

    @Override
    public void setCurrentAbilities(List<Ability> abilities) {
        this.currentAbilities = abilities;
    }

    @Override
    public void applyAbilities(PlayerEntity player) {
        if (this.getCurrentAbilities() != null && this.getCurrentMorph().isPresent()) {
            this.getCurrentAbilities().forEach(ability -> ability.enableAbility(player, this.getCurrentMorph().get()));
        }
    }

    @Override
    public void deapplyAbilities(PlayerEntity player) {
        if (this.getCurrentAbilities() != null) {
            this.getCurrentAbilities().forEach(ability -> ability.disableAbility(player, this.getCurrentMorph().get()));
        }
    }

    @Override
    public void useAbility(PlayerEntity player) {
        if (this.getCurrentAbilities() != null) {
            this.getCurrentAbilities().forEach(ability -> ability.onUsedAbility(player, this.getCurrentMorph().get()));
        }
    }

    @Override
    public boolean hasAbility(Ability ability) {
        if (this.getCurrentAbilities() != null) {
            return this.getCurrentAbilities().contains(ability);
        }
        return false;
    }

    @Override
    public int getLastAggroTimestamp() {
        return this.aggroTimestamp;
    }

    @Override
    public void setLastAggroTimestamp(int timestamp) {
        this.aggroTimestamp = timestamp;
    }

    @Override
    public int getLastAggroDuration() {
        return this.aggroDuration;
    }

    @Override
    public void setLastAggroDuration(int aggroDuration) {
        this.aggroDuration = aggroDuration;
    }
}

