/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityFactory;
import de.budschie.bmorph.capabilities.MorphCapabilityStorage;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MorphCapabilityAttacher
implements ICapabilitySerializable<CompoundNBT> {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("bmorph", "morph_cap");
    @CapabilityInject(value=IMorphCapability.class)
    public static final Capability<IMorphCapability> MORPH_CAP = null;
    LazyOptional<IMorphCapability> cap = LazyOptional.of(() -> MORPH_CAP.getDefaultInstance());

    @SubscribeEvent
    public static void onAttachCapsOnPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(CAPABILITY_NAME, (ICapabilityProvider)new MorphCapabilityAttacher());
        }
    }

    public MorphCapabilityAttacher() {
        if (MORPH_CAP == null) {
            throw new IllegalStateException("Why was the cap not injected?");
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMorphCapability.class, (Capability.IStorage)new MorphCapabilityStorage(), (Callable)new MorphCapabilityFactory());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return MORPH_CAP.orEmpty(cap, this.cap);
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)MORPH_CAP.getStorage().writeNBT(MORPH_CAP, this.cap.resolve().get(), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        MORPH_CAP.getStorage().readNBT(MORPH_CAP, this.cap.resolve().get(), null, (INBT)nbt);
    }
}

