/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.capabilities.blacklist;

import de.budschie.bmorph.capabilities.blacklist.WorldConfigHandler;
import java.util.HashMap;
import java.util.function.Supplier;

public enum ConfigManager {
    INSTANCE;

    private HashMap<Class<?>, Supplier<? extends WorldConfigHandler>> registeredConfigs = new HashMap();
    private HashMap<Class<?>, WorldConfigHandler> presentConfigs = new HashMap();

    public void saveAll() {
        this.presentConfigs.forEach((key, value) -> value.writeToFile());
    }

    public void serverShutdown() {
        this.saveAll();
        this.presentConfigs.clear();
    }

    public void loadAll() {
        this.registeredConfigs.forEach((key, value) -> {
            WorldConfigHandler instance = (WorldConfigHandler)value.get();
            this.presentConfigs.put((Class<?>)key, instance);
            instance.readFromFile();
        });
    }

    public <T> T get(Class<T> clazz) {
        if (this.presentConfigs.containsKey(clazz)) {
            return (T)this.presentConfigs.get(clazz);
        }
        throw new IllegalStateException("You may not retrieve world config handlers when they are not yet initialized.");
    }

    public <T extends WorldConfigHandler> void register(Class<T> clazz, Supplier<T> supplier) {
        this.registeredConfigs.put(clazz, supplier);
    }
}

