/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.commands.RemovableSuggestionProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class BlacklistCommand {
    public static void registerCommand(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"morphblacklist").requires(src -> src.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(SuggestionProviders.field_197505_d).executes(BlacklistCommand::addBlacklist)))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((SuggestionProvider)RemovableSuggestionProvider.INSTANCE).executes(BlacklistCommand::removeBlacklist)))).then(Commands.func_197057_a((String)"list").executes(BlacklistCommand::listBlacklist)));
    }

    private static int addBlacklist(CommandContext<CommandSource> ctx) {
        ResourceLocation arg;
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        if (blacklist.isInBlacklist(arg = (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class))) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Failed to add entry " + arg.toString() + " to the entity blacklist because that entry already exists."));
        } else {
            blacklist.addBlacklist(arg);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully added " + arg.toString() + " to the blacklist!"), true);
            blacklist.writeToFile();
        }
        return 0;
    }

    private static int listBlacklist(CommandContext<CommandSource> ctx) {
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        String conc = String.join((CharSequence)", ", (CharSequence[])blacklist.getBlacklist().stream().map(rs -> rs.toString()).toArray(String[]::new));
        StringBuilder builder = new StringBuilder();
        builder.append(TextFormatting.GREEN);
        boolean isSingular = blacklist.getBlacklist().size() == 1;
        builder.append("There ").append(isSingular ? "is" : "are").append(" currently ").append(blacklist.getBlacklist().size()).append(isSingular ? " entry" : " entries").append(" in the blacklist: ").append(conc);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 0;
    }

    private static int removeBlacklist(CommandContext<CommandSource> ctx) {
        ResourceLocation arg = (ResourceLocation)ctx.getArgument("entity", ResourceLocation.class);
        BlacklistData blacklist = ConfigManager.INSTANCE.get(BlacklistData.class);
        if (blacklist.isInBlacklist(arg)) {
            blacklist.removeBlacklist(arg);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully removed " + arg.toString() + " from the entity blacklist."), false);
            blacklist.writeToFile();
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Failed to remove entry " + arg.toString() + " from the entity blacklist because that entry doesn't exist yet."));
        }
        return 0;
    }
}

