/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.entity;

import com.mojang.authlib.GameProfile;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.entity.EntityRegistry;
import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.PlayerMorphItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.DataSerializerEntry;

public class MorphEntity
extends Entity {
    private static final PlayerMorphItem DEFAULT = MorphManagerHandlers.PLAYER.createMorph(EntityType.field_200729_aH, new GameProfile(new UUID(0L, 0L), "SteveMcSteve"));
    private static final DataParameter<MorphItem> MORPH_ITEM = EntityDataManager.func_187226_a(MorphEntity.class, (IDataSerializer)((DataSerializerEntry)EntityRegistry.MORPH_SERIALIZER.get()).getSerializer());

    public MorphEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public MorphEntity(World world, MorphItem morphItem) {
        super((EntityType)EntityRegistry.MORPH_ENTITY.get(), world);
        this.func_184212_Q().func_187227_b(MORPH_ITEM, (Object)morphItem);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 6000) {
            this.func_70106_y();
        }
        if (!this.func_233570_aj_()) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - (double)0.04f, this.func_213322_ci().field_72449_c);
        }
        if (!this.field_70122_E || MorphEntity.func_213296_b((Vector3d)this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity : list) {
                if (!(entity instanceof PlayerEntity)) continue;
                PlayerEntity player = (PlayerEntity)entity;
                LazyOptional lazyCaps = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
                if (this.field_70170_p.field_72995_K || !lazyCaps.isPresent()) continue;
                IMorphCapability resolvedCaps = (IMorphCapability)lazyCaps.resolve().get();
                if (!((MorphItem)this.field_70180_af.func_187225_a(MORPH_ITEM)).isAllowedToPickUp(player) || resolvedCaps.getMorphList().contains(this.getMorphItem())) continue;
                resolvedCaps.getMorphList().addToMorphList(this.getMorphItem());
                resolvedCaps.syncMorphAcquisition(player, this.getMorphItem());
                this.func_70106_y();
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 2.0f, this.field_70146_Z.nextFloat() - 0.5f + 1.0f);
            }
        }
    }

    protected void func_213282_i(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vector3d vector3d = new Vector3d(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, direction1);
            if (this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_235785_r_((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)) continue;
            double d1 = vector3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.func_176743_c().func_179524_a();
        Vector3d vector3d1 = this.func_213322_ci().func_186678_a(0.75);
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.func_213293_j(f1 * f, vector3d1.field_72448_b, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.func_213293_j(vector3d1.field_72450_a, f1 * f, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, f1 * f);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MORPH_ITEM, (Object)DEFAULT);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.field_70180_af.func_187227_b(MORPH_ITEM, (Object)MorphHandler.deserializeMorphItem(nbt.func_74775_l("MorphData")));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_218657_a("MorphData", (INBT)((MorphItem)this.field_70180_af.func_187225_a(MORPH_ITEM)).serialize());
    }

    public MorphItem getMorphItem() {
        return (MorphItem)this.field_70180_af.func_187225_a(MORPH_ITEM);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_82150_aj() {
        return false;
    }
}

