/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.events;

import de.budschie.bmorph.api_interact.ShrinkAPIInteractor;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.entity.MorphEntity;
import de.budschie.bmorph.json_integration.MorphAbilityManager;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.PlayerMorphEvent;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.AbilityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    public static int AGGRO_TICKS_TO_PASS = 200;
    public static final MorphAbilityManager MORPH_ABILITY_MANAGER = new MorphAbilityManager();

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player;
        LazyOptional cap;
        if (!event.getEntity().field_70170_p.field_72995_K && (cap = (player = event.getPlayer()).getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Pre(player, (IMorphCapability)cap.resolve().get(), ((IMorphCapability)cap.resolve().get()).getCurrentMorph().orElse(null)));
            ((IMorphCapability)cap.resolve().get()).getCurrentMorph().ifPresent(morph -> ((IMorphCapability)cap.resolve().get()).setCurrentAbilities(MORPH_ABILITY_MANAGER.getAbilitiesFor((MorphItem)morph)));
            ((IMorphCapability)cap.resolve().get()).syncWithClients(player);
            ((IMorphCapability)cap.resolve().get()).applyHealthOnPlayer(player);
            ((IMorphCapability)cap.resolve().get()).applyAbilities(player);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Post(player, (IMorphCapability)cap.resolve().get(), ((IMorphCapability)cap.resolve().get()).getCurrentMorph().orElse(null)));
        }
    }

    @SubscribeEvent
    public static void onPlayerIsBeingLoaded(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MorphUtil.processCap(player, resolved -> resolved.syncWithClient(player, (ServerPlayerEntity)event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onRegisterReloadResourceLoaders(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)MORPH_ABILITY_MANAGER);
    }

    @SubscribeEvent
    public static void onPlayerStoppedBeingLoaded(PlayerEvent.StopTracking event) {
    }

    @SubscribeEvent
    public static void onPlayerKilledLivingEntity(LivingDeathEvent event) {
        MorphItem morphItem;
        PlayerEntity player;
        LazyOptional playerMorph;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof PlayerEntity && (playerMorph = (player = (PlayerEntity)event.getSource().func_76346_g()).getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent() && (morphItem = MorphManagerHandlers.createMorphFromDeadEntity(event.getEntity())) != null) {
            boolean shouldMorph;
            IMorphCapability resolved = (IMorphCapability)playerMorph.resolve().get();
            boolean bl = shouldMorph = !ConfigManager.INSTANCE.get(BlacklistData.class).isInBlacklist(event.getEntity().func_200600_R().getRegistryName());
            if (!resolved.getMorphList().contains(morphItem) && shouldMorph) {
                MorphEntity morphEntity = new MorphEntity(event.getEntity().field_70170_p, morphItem);
                morphEntity.func_70107_b(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_());
                event.getEntity().field_70170_p.func_217376_c((Entity)morphEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            MorphUtil.processCap(event.getPlayer(), resolved -> resolved.syncWithClients(event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || ServerSetup.server.func_200252_aR().func_223586_b(BMorphMod.KEEP_MORPH_INVENTORY)) {
            LazyOptional oldCap = event.getOriginal().getCapability(MorphCapabilityAttacher.MORPH_CAP);
            LazyOptional newCap = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (oldCap.isPresent() && newCap.isPresent()) {
                IMorphCapability oldResolved = (IMorphCapability)oldCap.resolve().get();
                IMorphCapability newResolved = (IMorphCapability)newCap.resolve().get();
                newResolved.setMorphList(oldResolved.getMorphList());
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Pre(event.getPlayer(), newResolved, newResolved.getCurrentMorph().orElse(null)));
                oldResolved.getCurrentMorphIndex().ifPresent(morph -> newResolved.setMorph((int)morph));
                oldResolved.getCurrentMorphItem().ifPresent(morph -> newResolved.setMorph((MorphItem)morph));
                newResolved.setCurrentAbilities(oldResolved.getCurrentAbilities());
                MinecraftForge.EVENT_BUS.post((Event)new PlayerMorphEvent.Server.Post(event.getPlayer(), newResolved, newResolved.getCurrentMorph().orElse(null)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedEvent(PlayerEvent.PlayerRespawnEvent event) {
        LazyOptional cap;
        if (!event.getPlayer().field_70170_p.field_72995_K && ServerSetup.server.func_200252_aR().func_223586_b(BMorphMod.KEEP_MORPH_INVENTORY) && (cap = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            resolved.syncWithClients(event.getPlayer());
            resolved.applyHealthOnPlayer(event.getPlayer());
            resolved.applyAbilities(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerDeathEvent(LivingDeathEvent event) {
        PlayerEntity player;
        LazyOptional cap;
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K && (cap = (player = (PlayerEntity)event.getEntityLiving()).getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            resolved.deapplyAbilities(player);
            if (!ServerSetup.server.func_200252_aR().func_223586_b(BMorphMod.KEEP_MORPH_INVENTORY)) {
                for (MorphItem item : resolved.getMorphList().getMorphArrayList()) {
                    MorphEntity morphEntity = new MorphEntity(player.field_70170_p, item);
                    morphEntity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                    player.field_70170_p.func_217376_c((Entity)morphEntity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTakingDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (event.getSource().func_76347_k() && resolved.hasAbility((Ability)AbilityRegistry.NO_FIRE_DAMAGE_ABILITY.get())) {
                    event.setCanceled(true);
                } else if (event.getSource() == DamageSource.field_76379_h && resolved.hasAbility((Ability)AbilityRegistry.NO_FALL_DAMAGE_ABILITY.get())) {
                    event.setCanceled(true);
                }
            }
        } else if (event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving() instanceof IMob && !event.getEntity().field_70170_p.field_72995_K) {
            PlayerEntity source = (PlayerEntity)event.getSource().func_76346_g();
            LazyOptional cap = source.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            Events.aggro((IMorphCapability)cap.resolve().get(), ServerSetup.server.func_200252_aR().func_223592_c(BMorphMod.MORPH_AGGRO_DURATION));
        }
    }

    @SubscribeEvent
    public static void onChangedPose(TickEvent.PlayerTickEvent event) {
        MorphUtil.processCap(event.player, cap -> {
            if (cap.hasAbility((Ability)AbilityRegistry.FLY_ABILITY.get()) && event.player.field_71075_bZ.field_75100_b) {
                event.player.func_213301_b(Pose.STANDING);
                event.player.setForcedPose(null);
            }
            if (cap.getCurrentMorph().isPresent() && event.player.func_174813_aQ().field_72337_e - event.player.func_174813_aQ().field_72338_b < 1.0 && event.player.func_213283_Z() == Pose.SWIMMING && !event.player.func_203007_ba()) {
                event.player.func_213301_b(Pose.STANDING);
            }
        });
    }

    @SubscribeEvent
    public static void onMorphedClient(PlayerMorphEvent.Client.Post event) {
        event.getPlayer().func_213323_x_();
    }

    @SubscribeEvent
    public static void onMorphedServer(PlayerMorphEvent.Server.Post event) {
        event.getPlayer().func_213323_x_();
    }

    private static void aggro(IMorphCapability capability, int aggroDuration) {
        capability.setLastAggroTimestamp(ServerSetup.server.func_71259_af());
        capability.setLastAggroDuration(aggroDuration);
    }

    @SubscribeEvent
    public static void onTargetBeingSet(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof MobEntity && event.getTarget() instanceof PlayerEntity && event.getTarget() != event.getEntityLiving().func_70643_av()) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity aggressor = (MobEntity)event.getEntityLiving();
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (resolved.getCurrentMorph().isPresent()) {
                    if (!resolved.hasAbility((Ability)AbilityRegistry.MOB_ATTACK_ABILITY.get()) && ServerSetup.server.func_71259_af() - resolved.getLastAggroTimestamp() > resolved.getLastAggroDuration()) {
                        aggressor.func_70624_b(null);
                    } else {
                        Events.aggro(resolved, ServerSetup.server.func_200252_aR().func_223592_c(BMorphMod.MORPH_AGGRO_DURATION));
                    }
                } else {
                    Events.aggro(resolved, ServerSetup.server.func_200252_aR().func_223592_c(BMorphMod.MORPH_AGGRO_DURATION));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ServerSetup.server.func_184103_al().func_181057_v().forEach(player -> {
            LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (resolved.hasAbility((Ability)AbilityRegistry.CLIMBING_ABILITY.get()) && player.field_70123_F) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)0.1f, 0.0));
                }
                if (resolved.hasAbility((Ability)AbilityRegistry.WATER_BREATHING_ABILITY.get()) && player.func_70090_H()) {
                    player.func_70050_g(280);
                }
                if (resolved.hasAbility((Ability)AbilityRegistry.WATER_DISLIKE_ABILITY.get()) && player.func_203008_ap()) {
                    player.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCalculatingAABB(EntityEvent.Size event) {
        PlayerEntity player;
        LazyOptional cap;
        if (event.getEntity() instanceof PlayerEntity && (cap = (player = (PlayerEntity)event.getEntity()).getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) {
            float divisor = ShrinkAPIInteractor.getInteractor().getShrinkingValue(player);
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            resolved.getCurrentMorph().ifPresent(item -> {
                Entity createdEntity = item.createEntity(event.getEntity().field_70170_p);
                createdEntity.func_213301_b(event.getPose());
                EntitySize newSize = createdEntity.func_213305_a(Pose.STANDING);
                if (ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
                    newSize = newSize.func_220312_a(1.6f / divisor, 1.0f / divisor);
                }
                if (event.getPose() == Pose.CROUCHING) {
                    newSize = newSize.func_220312_a(1.0f, 0.85f);
                }
                event.setNewSize(newSize, false);
                event.setNewEyeHeight(newSize.field_220316_b * 0.85f);
            });
        }
    }
}

