/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.gui;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.gui.NewMorphGui;
import de.budschie.bmorph.main.ClientSetup;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.AbilityRegistry;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.MorphRequestAbilityUsage;
import de.budschie.bmorph.network.MorphRequestMorphIndexChange;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MorphGuiHandler {
    private static boolean toggle = false;
    private static ArrayList<EyeHeightChangePair> scheduledChanges = new ArrayList();

    public static void toggle() {
        boolean bl = toggle = !toggle;
        if (toggle) {
            LazyOptional cap = Minecraft.func_71410_x().field_71439_g.getCapability(MorphCapabilityAttacher.MORPH_CAP);
            cap.ifPresent(resolved -> resolved.getCurrentMorphIndex().ifPresent(index -> NewMorphGui.setScroll(index + 1)));
            NewMorphGui.showGui();
        } else {
            NewMorphGui.hideGui();
        }
    }

    @SubscribeEvent
    public static void onPressedKey(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().field_71441_e.func_217369_A().forEach(player -> {
                LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
                if (cap.isPresent()) {
                    IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                    if (resolved.hasAbility((Ability)AbilityRegistry.CLIMBING_ABILITY.get()) && player.field_70123_F && !player.field_71075_bZ.field_75100_b) {
                        Vector3d toSet = player.func_213322_ci().func_72441_c(0.0, (double)0.2f, 0.0);
                        player.func_213317_d(new Vector3d(toSet.field_72450_a, Math.min(toSet.field_72448_b, (double)0.2f), toSet.field_72449_c));
                    }
                    if (resolved.hasAbility((Ability)AbilityRegistry.WATER_BREATHING_ABILITY.get()) && player.func_70090_H()) {
                        player.func_70050_g(280);
                    }
                }
            });
            if (ClientSetup.TOGGLE_MORPH_UI.func_151468_f()) {
                MorphGuiHandler.toggle();
            }
            if (ClientSetup.USE_ABILITY_KEY.func_151468_f()) {
                MainNetworkChannel.INSTANCE.sendToServer((Object)new MorphRequestAbilityUsage.MorphRequestAbilityUsagePacket());
            }
            if (toggle && ClientSetup.SCROLL_DOWN_MORPH_UI.func_151468_f()) {
                NewMorphGui.scroll(1);
            }
            if (toggle && ClientSetup.SCROLL_UP_MORPH_UI.func_151468_f()) {
                NewMorphGui.scroll(-1);
            }
        }
    }

    @SubscribeEvent
    public static void onPressedKeyboardKeyRaw(InputEvent.KeyInputEvent event) {
        if (toggle && ClientSetup.MORPH_UI.func_151468_f()) {
            MorphGuiHandler.toggle();
            MainNetworkChannel.INSTANCE.sendToServer((Object)new MorphRequestMorphIndexChange.RequestMorphIndexChangePacket(NewMorphGui.getScroll() - 1));
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (toggle && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            NewMorphGui.render(event.getMatrixStack());
        }
    }

    public static void scheduleEyeHeightChange(float newEyeHeight, PlayerEntity player) {
        EyeHeightChangePair pair = new EyeHeightChangePair();
        pair.newEyeHeight = newEyeHeight;
        pair.player = player;
        scheduledChanges.add(pair);
    }

    private static class EyeHeightChangePair {
        float newEyeHeight;
        PlayerEntity player;

        private EyeHeightChangePair() {
        }
    }
}

