/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.morph.MorphItem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class NewMorphGui {
    public static ArrayList<MorphWidget> morphWidgets = new ArrayList();
    private static int scroll = 0;

    public static void showGui() {
        LazyOptional cap = Minecraft.func_71410_x().field_71439_g.getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (cap.isPresent()) {
            IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
            ArrayList<MorphItem> morphList = resolved.getMorphList().getMorphArrayList();
            morphWidgets.add(new MorphWidget(null));
            for (MorphItem item : morphList) {
                morphWidgets.add(new MorphWidget(item));
            }
        }
    }

    public static void hideGui() {
        morphWidgets = new ArrayList();
    }

    public static void render(MatrixStack matrixStack) {
        scroll = Math.max(Math.min(scroll, morphWidgets.size() - 1), 0);
        int startY = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 - MorphWidget.getHeight() / 2 - scroll * MorphWidget.getHeight();
        int advanceY = 0;
        int rendered = 0;
        for (int i = 0; i < morphWidgets.size(); ++i) {
            if (startY + advanceY + MorphWidget.getHeight() > 0 && startY + advanceY < Minecraft.func_71410_x().func_228018_at_().func_198087_p()) {
                ++rendered;
                MorphWidget widget = morphWidgets.get(i);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(6.0, (double)(startY + advanceY), 0.0);
                widget.render(matrixStack, i == scroll);
                matrixStack.func_227865_b_();
            }
            advanceY += MorphWidget.getHeight();
        }
    }

    public static void scroll(int amount) {
        scroll += amount;
    }

    public static void setScroll(int scroll) {
        NewMorphGui.scroll = scroll;
    }

    public static int getScroll() {
        return scroll;
    }

    public static ArrayList<MorphWidget> getMorphWidgets() {
        return morphWidgets;
    }

    public static class MorphWidget {
        public static final int WIDGET_WIDTH = 48;
        public static final int WIDGET_HEIGHT = 64;
        public static final double SCALE_FACTOR = 1.3;
        public static final float ENTITY_SCALE_FACTOR = 30.0f;
        public static final Quaternion ENTITY_ROTATION = new Quaternion(10.0f, 45.0f, 0.0f, true);
        private static final ResourceLocation MORPH_WINDOW_NORMAL = new ResourceLocation("bmorph", "textures/gui/morph_window_normal.png");
        private static final ResourceLocation MORPH_WINDOW_SELECTED = new ResourceLocation("bmorph", "textures/gui/morph_window_selected.png");
        private static final ResourceLocation DEMORPH = new ResourceLocation("bmorph", "textures/gui/demorph.png");
        Optional<Entity> morphEntity = Optional.empty();
        MorphItem morphItem;

        public MorphWidget(MorphItem morphItem) {
            this.morphItem = morphItem;
        }

        public void render(MatrixStack stack, boolean isSelected) {
            RenderSystem.enableBlend();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(isSelected ? MORPH_WINDOW_SELECTED : MORPH_WINDOW_NORMAL);
            AbstractGui.func_238463_a_((MatrixStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight(), (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight());
            if (this.morphItem == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DEMORPH);
                AbstractGui.func_238463_a_((MatrixStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight(), (int)MorphWidget.getWidth(), (int)MorphWidget.getHeight());
            } else {
                if (!this.morphEntity.isPresent()) {
                    this.morphEntity = Optional.of(this.morphItem.createEntity((World)Minecraft.func_71410_x().field_71441_e));
                }
                IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                AxisAlignedBB aabb = this.morphEntity.get().func_174813_aQ();
                stack.func_227860_a_();
                stack.func_227861_a_(30.0, 70.0, 50.0);
                stack.func_227862_a_(30.0f, -30.0f, 30.0f);
                stack.func_227863_a_(ENTITY_ROTATION);
                Minecraft.func_71410_x().func_175598_ae().func_229084_a_(this.morphEntity.get(), 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, (IRenderTypeBuffer)buffer, 0xF000F0);
                buffer.func_228461_a_();
                stack.func_227865_b_();
            }
        }

        public static int getHeight() {
            return 83;
        }

        public static int getWidth() {
            return 62;
        }
    }
}

