/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.json_integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.AbilityRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MorphAbilityManager
extends JsonReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private HashMap<EntityType<?>, List<Ability>> abilityLookup = new HashMap();

    public MorphAbilityManager() {
        super(GSON, "morph_abilities");
    }

    @Nullable
    public List<Ability> getAbilitiesFor(EntityType<?> entity) {
        return this.abilityLookup.get(entity);
    }

    @Nullable
    public List<Ability> getAbilitiesFor(MorphItem morphItem) {
        return this.getAbilitiesFor(morphItem.getEntityType());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.abilityLookup.clear();
        HashMap<String, MorphAbilityEntry> abilityEntries = new HashMap<String, MorphAbilityEntry>();
        objectIn.forEach((resourceLocation, json) -> {
            try {
                int i;
                JsonObject root = json.getAsJsonObject();
                String entity = root.get("entity_type").getAsString();
                JsonArray grantedAbilities = root.getAsJsonArray("grant");
                JsonArray revokedAbilities = root.getAsJsonArray("revoke");
                MorphAbilityEntry entry = abilityEntries.computeIfAbsent(entity, key -> new MorphAbilityEntry());
                for (i = 0; i < grantedAbilities.size(); ++i) {
                    entry.grantAbility(grantedAbilities.get(i).getAsString());
                }
                for (i = 0; i < revokedAbilities.size(); ++i) {
                    entry.revokeAbility(revokedAbilities.get(i).getAsString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        abilityEntries.forEach((entity, entry) -> {
            try {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entity));
                if (!ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(entity))) {
                    LOGGER.warn(String.format("The given entity %s is not known to the game. Skipping this entry.", entity));
                } else {
                    List<Ability> resolvedAbilities = entry.resolve();
                    this.abilityLookup.put(entityType, resolvedAbilities);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private static class MorphAbilityEntry {
        private HashSet<String> grantedAbilities = new HashSet();
        private HashSet<String> revokedAbilities = new HashSet();

        private MorphAbilityEntry() {
        }

        public void grantAbility(String abilityResourceLocation) {
            this.grantedAbilities.add(abilityResourceLocation);
        }

        public void revokeAbility(String abilityResourceLocation) {
            this.revokedAbilities.add(abilityResourceLocation);
        }

        public List<Ability> resolve() {
            return this.grantedAbilities.stream().filter(granted -> !this.revokedAbilities.contains(granted)).filter(exists -> {
                if (!AbilityRegistry.REGISTRY.get().containsKey(new ResourceLocation(exists))) {
                    LOGGER.warn(String.format("Ability %s does not exist. Please check if every mod is loaded, or if you made a typo. Skipping this ability.", exists));
                    return false;
                }
                return true;
            }).map(strRaw -> (Ability)AbilityRegistry.REGISTRY.get().getValue(new ResourceLocation(strRaw))).collect(Collectors.toList());
        }
    }
}

