/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.render_handler.RenderHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public PlayerRendererMixin(EntityRendererManager rendererManager, PlayerModel<AbstractClientPlayerEntity> entityModelIn, float shadowSizeIn) {
        super(rendererManager, entityModelIn, shadowSizeIn);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderRightArm(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;ILnet/minecraft/client/entity/player/AbstractClientPlayerEntity;)V"}, cancellable=true)
    private void renderRightArm(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn, CallbackInfo info) {
        if (this.checkMorphPresent((PlayerEntity)playerIn)) {
            RenderHandler.checkCache((PlayerEntity)playerIn);
            info.cancel();
            Entity cachedEntity = RenderHandler.cachedEntities.get(playerIn.func_110124_au());
            EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(cachedEntity);
            if (renderer instanceof LivingRenderer) {
                ModelRenderer armRenderer = null;
                LivingRenderer living = (LivingRenderer)renderer;
                if (living.field_77045_g instanceof BipedModel) {
                    armRenderer = ((BipedModel)living.field_77045_g).field_178723_h;
                }
                if (living.field_77045_g instanceof QuadrupedModel) {
                    armRenderer = ((QuadrupedModel)living.field_77045_g).field_78147_e;
                }
                if (armRenderer != null) {
                    this.renderArm(false, playerIn, armRenderer, matrixStackIn, combinedLightIn, bufferIn, living, (LivingEntity)cachedEntity, combinedLightIn);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeftArm(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;ILnet/minecraft/client/entity/player/AbstractClientPlayerEntity;)V"}, cancellable=true)
    private void renderLeftArm(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn, CallbackInfo info) {
        if (this.checkMorphPresent((PlayerEntity)playerIn)) {
            RenderHandler.checkCache((PlayerEntity)playerIn);
            info.cancel();
            Entity cachedEntity = RenderHandler.cachedEntities.get(playerIn.func_110124_au());
            EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(cachedEntity);
            if (renderer instanceof LivingRenderer) {
                ModelRenderer armRenderer = null;
                LivingRenderer living = (LivingRenderer)renderer;
                if (living.field_77045_g instanceof BipedModel) {
                    armRenderer = ((BipedModel)living.field_77045_g).field_178723_h;
                }
                if (living.field_77045_g instanceof QuadrupedModel) {
                    armRenderer = ((QuadrupedModel)living.field_77045_g).field_78144_f;
                }
                if (armRenderer != null) {
                    this.renderArm(true, playerIn, armRenderer, matrixStackIn, combinedLightIn, bufferIn, living, (LivingEntity)cachedEntity, combinedLightIn);
                }
            }
        }
    }

    @Shadow
    private void func_177137_d(AbstractClientPlayerEntity clientPlayer) {
    }

    private void renderArm(boolean isLeft, AbstractClientPlayerEntity player, ModelRenderer arm, MatrixStack matrixStack, int combinedLightIn, IRenderTypeBuffer buffer, LivingRenderer<? super LivingEntity, ?> renderer, LivingEntity entity, int light) {
        matrixStack.func_227860_a_();
        if (renderer.field_77045_g instanceof QuadrupedModel) {
            matrixStack.func_227861_a_(isLeft ? 0.1 : -0.1, -0.6, 0.5);
        }
        this.func_177137_d(player);
        renderer.field_77045_g.field_217112_c = 0.0f;
        if (renderer instanceof BipedRenderer) {
            BipedRenderer casted = (BipedRenderer)renderer;
            ((BipedModel)casted.field_77045_g).field_205061_a = 0.0f;
            ((BipedModel)casted.field_77045_g).field_228270_o_ = false;
        }
        renderer.field_77045_g.func_225597_a_((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.field_78795_f = 0.0f;
        arm.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)renderer.func_110775_a((Entity)entity))), combinedLightIn, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }

    private boolean checkMorphPresent(PlayerEntity player) {
        return player != null && player.getCapability(MorphCapabilityAttacher.MORPH_CAP).isPresent() && ((IMorphCapability)player.getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve().get()).getCurrentMorph().isPresent();
    }
}

