/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphManagerHandlers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class FallbackMorphItem
extends MorphItem {
    private CompoundNBT entityData;
    private EntityType<?> entityType;

    public FallbackMorphItem(CompoundNBT entityData, EntityType<?> entityType) {
        super("fallback_morph_item");
        this.entityData = entityData;
        this.entityType = entityType;
        entityData.func_74778_a("id", entityType.getRegistryName().toString());
    }

    public FallbackMorphItem(EntityType<?> entityType) {
        this(new CompoundNBT(), entityType);
    }

    public FallbackMorphItem() {
        super("fallback_morph_item");
    }

    @Override
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public Entity createEntity(World world) {
        return EntityType.func_220335_a((CompoundNBT)this.entityData, (World)world, entity -> entity);
    }

    @Override
    public void deserializeAdditional(CompoundNBT nbt) {
        this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.func_74779_i("id")));
        this.entityData = nbt;
    }

    @Override
    public CompoundNBT serializeAdditional() {
        return this.entityData;
    }

    public int hashCode() {
        return MorphManagerHandlers.FALLBACK.hashCodeFor(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FallbackMorphItem) {
            FallbackMorphItem casted = (FallbackMorphItem)obj;
            return MorphManagerHandlers.FALLBACK.equalsFor(this, casted);
        }
        return false;
    }
}

