/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.FallbackMorphItem;
import de.budschie.bmorph.morph.IMorphManager;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;

public class FallbackMorphManager
implements IMorphManager<FallbackMorphItem, Void> {
    private HashMap<String, SpecialDataHandler> dataHandlers = new HashMap();

    @Override
    public boolean doesManagerApplyTo(EntityType<?> type) {
        return true;
    }

    @Override
    public FallbackMorphItem createMorphFromEntity(Entity entity) {
        return (FallbackMorphItem)this.createMorph(entity.func_200600_R(), entity.serializeNBT(), null);
    }

    @Override
    public FallbackMorphItem createMorph(EntityType<?> entity, CompoundNBT nbt, Void data, boolean forceNBT) {
        SpecialDataHandler handler = this.dataHandlers.get(EntityType.func_200718_a(entity).toString());
        if (!forceNBT) {
            nbt = handler != null ? handler.getDefaultApplier().apply(nbt) : new CompoundNBT();
        }
        return new FallbackMorphItem(nbt, entity);
    }

    @Override
    public FallbackMorphItem createMorph(EntityType<?> entity, Void data) {
        SpecialDataHandler handler = this.dataHandlers.get(EntityType.func_200718_a(entity).toString());
        if (handler == null) {
            return new FallbackMorphItem(entity);
        }
        CompoundNBT nbt = new CompoundNBT();
        return new FallbackMorphItem(handler.getDefaultApplier().apply(nbt), entity);
    }

    @Override
    public boolean equalsFor(FallbackMorphItem item1, FallbackMorphItem item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        if (item1.getEntityType() != item2.getEntityType()) {
            return false;
        }
        SpecialDataHandler handler = this.dataHandlers.get(EntityType.func_200718_a(item1.getEntityType()).toString());
        return handler == null ? true : handler.getEqualsMethod().test(item1, item2);
    }

    @Override
    public int hashCodeFor(FallbackMorphItem item) {
        SpecialDataHandler handler = this.dataHandlers.get(EntityType.func_200718_a(item.getEntityType()).toString());
        if (handler == null) {
            return EntityType.func_200718_a(item.getEntityType()).hashCode();
        }
        return handler.getHashFunction().apply(item.getEntityType(), item.serializeAdditional());
    }

    public void addDataHandler(EntityType<?> entityType, SpecialDataHandler dataHandler) {
        this.dataHandlers.put(EntityType.func_200718_a(entityType).toString(), dataHandler);
    }

    public static class SpecialDataHandler {
        private BiPredicate<FallbackMorphItem, FallbackMorphItem> equalsMethod;
        private BiFunction<EntityType<?>, CompoundNBT, Integer> hashFunction;
        private Function<CompoundNBT, CompoundNBT> defaultApplier;

        public SpecialDataHandler(BiPredicate<FallbackMorphItem, FallbackMorphItem> equalsMethod, BiFunction<EntityType<?>, CompoundNBT, Integer> hashFunction, Function<CompoundNBT, CompoundNBT> defaultApplier) {
            this.equalsMethod = equalsMethod;
            this.hashFunction = hashFunction;
            this.defaultApplier = defaultApplier;
        }

        public BiPredicate<FallbackMorphItem, FallbackMorphItem> getEqualsMethod() {
            return this.equalsMethod;
        }

        public BiFunction<EntityType<?>, CompoundNBT, Integer> getHashFunction() {
            return this.hashFunction;
        }

        public Function<CompoundNBT, CompoundNBT> getDefaultApplier() {
            return this.defaultApplier;
        }
    }
}

