/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;

public abstract class MorphItem {
    private String morphItemId;

    MorphItem(String morphItemId) {
        this.morphItemId = morphItemId;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.getMorphItemId());
        nbt.func_218657_a("additional", (INBT)this.serializeAdditional());
        return nbt;
    }

    public void deserialize(CompoundNBT nbt) {
        if (!nbt.func_74779_i("id").equals(this.getMorphItemId())) {
            throw new IllegalArgumentException("The wrong morph item is being serialized. Please report this bug to the developer.");
        }
        this.deserializeAdditional(nbt.func_74775_l("additional"));
    }

    public abstract void deserializeAdditional(CompoundNBT var1);

    public abstract CompoundNBT serializeAdditional();

    public abstract EntityType<?> getEntityType();

    public abstract Entity createEntity(World var1);

    public boolean isAllowedToPickUp(PlayerEntity picker) {
        return true;
    }

    public String getMorphItemId() {
        return this.morphItemId;
    }
}

