/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class MorphList {
    private HashSet<MorphItem> playerMorphItems = new HashSet();
    private ArrayList<MorphItem> morphArrayList = new ArrayList();

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        Iterator<MorphItem> it = this.morphArrayList.iterator();
        for (int i = 0; i < this.morphArrayList.size(); ++i) {
            tag.func_218657_a(Integer.valueOf(i).toString(), (INBT)it.next().serialize());
        }
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        Set keys = tag.func_150296_c();
        for (String str : keys) {
            CompoundNBT morphTag = tag.func_74775_l(str);
            MorphItem item = MorphHandler.deserializeMorphItem(morphTag);
            this.playerMorphItems.add(item);
            this.morphArrayList.add(item);
        }
    }

    public void serializePacket(PacketBuffer packet) {
        packet.writeInt(this.morphArrayList.size());
        for (MorphItem item : this.morphArrayList) {
            packet.func_150786_a(item.serialize());
        }
    }

    public void deserializePacket(PacketBuffer packet) {
        int amount = packet.readInt();
        this.morphArrayList = new ArrayList(amount);
        for (int i = 0; i < amount; ++i) {
            this.morphArrayList.add(MorphHandler.deserializeMorphItem(packet.func_150793_b()));
        }
    }

    public void addToMorphList(MorphItem item) {
        this.playerMorphItems.add(item);
        this.morphArrayList.add(item);
    }

    public void removeFromMorphList(int index) {
        MorphItem item = this.morphArrayList.remove(index);
        this.playerMorphItems.remove(item);
    }

    public boolean contains(MorphItem item) {
        return this.playerMorphItems.contains(item);
    }

    public ArrayList<MorphItem> getMorphArrayList() {
        return this.morphArrayList;
    }
}

