/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph;

import de.budschie.bmorph.morph.FallbackMorphManager;
import de.budschie.bmorph.morph.IMorphManager;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.PlayerMorphManager;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;

public class MorphManagerHandlers {
    public static final PlayerMorphManager PLAYER = new PlayerMorphManager();
    public static final FallbackMorphManager FALLBACK = new FallbackMorphManager();
    private static ArrayList<IMorphManager<?, ?>> morphManagers = new ArrayList();

    public static void registerDefaultManagers() {
        MorphManagerHandlers.registerMorphManager(FALLBACK);
        MorphManagerHandlers.registerMorphManager(PLAYER);
    }

    public static void registerMorphManager(IMorphManager<?, ?> manager) {
        morphManagers.add(manager);
    }

    @Nullable
    public static MorphItem createMorphFromDeadEntity(Entity killedEntity) {
        for (int i = morphManagers.size() - 1; i >= 0; --i) {
            IMorphManager<?, ?> manager = morphManagers.get(i);
            if (!manager.doesManagerApplyTo(killedEntity.func_200600_R())) continue;
            return manager.createMorphFromEntity(killedEntity);
        }
        return null;
    }
}

