/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.AbstractEventAbility;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PassiveTickAbility
extends AbstractEventAbility {
    private int updateDuration = 0;
    private int lastUpdate = 0;
    private BiConsumer<PlayerEntity, IMorphCapability> handleUpdate;

    public PassiveTickAbility(int updateDuration, BiConsumer<PlayerEntity, IMorphCapability> handleUpdate) {
        this.updateDuration = updateDuration;
        this.handleUpdate = handleUpdate;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        int tickCounter = ServerSetup.server.func_71259_af();
        if (this.lastUpdate + this.updateDuration >= tickCounter) {
            this.lastUpdate = tickCounter;
            for (UUID uuid : this.trackedPlayers) {
                LazyOptional cap;
                ServerPlayerEntity player = ServerSetup.server.func_184103_al().func_177451_a(uuid);
                if (player == null || !(cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP)).isPresent()) continue;
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                this.handleUpdate.accept((PlayerEntity)player, resolved);
            }
        }
    }

    @Override
    public void onUsedAbility(PlayerEntity player, MorphItem currentMorph) {
    }
}

