/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;

public class MorphAddedSynchronizer
implements ISimpleImplPacket<MorphAddedPacket> {
    @Override
    public void encode(MorphAddedPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.getPlayerUUID());
        buffer.func_150786_a(packet.getAddedMorph().serialize());
    }

    @Override
    public MorphAddedPacket decode(PacketBuffer buffer) {
        return new MorphAddedPacket(buffer.func_179253_g(), MorphHandler.deserializeMorphItem(buffer.func_150793_b()));
    }

    @Override
    public void handle(MorphAddedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional cap = Minecraft.func_71410_x().field_71441_e.func_217371_b(packet.getPlayerUUID()).getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                resolved.addToMorphList(packet.getAddedMorph());
            }
        });
    }

    public static class MorphAddedPacket {
        UUID playerUUID;
        MorphItem addedMorph;

        public MorphAddedPacket(UUID playerUUID, MorphItem addedMorph) {
            this.playerUUID = playerUUID;
            this.addedMorph = addedMorph;
        }

        public MorphItem getAddedMorph() {
            return this.addedMorph;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

