/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphList;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;

public class MorphCapabilityFullSynchronizer
implements ISimpleImplPacket<MorphPacket> {
    @Override
    public void encode(MorphPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.player);
        packet.morphList.serializePacket(buffer);
        buffer.writeBoolean(packet.entityData.isPresent());
        buffer.writeBoolean(packet.entityIndex.isPresent());
        packet.getEntityData().ifPresent(data -> buffer.func_150786_a(data.serialize()));
        packet.getEntityIndex().ifPresent(data -> buffer.writeInt(data.intValue()));
        buffer.writeInt(packet.getAbilities().size());
        for (String str : packet.getAbilities()) {
            buffer.func_180714_a(str);
        }
    }

    @Override
    public MorphPacket decode(PacketBuffer buffer) {
        UUID playerUUID = buffer.func_179253_g();
        MorphList morphList = new MorphList();
        morphList.deserializePacket(buffer);
        Optional<MorphItem> toMorph = Optional.empty();
        Optional<Integer> entityIndex = Optional.empty();
        boolean hasMorph = buffer.readBoolean();
        boolean hasIndex = buffer.readBoolean();
        if (hasMorph) {
            toMorph = Optional.of(MorphHandler.deserializeMorphItem(buffer.func_150793_b()));
        }
        if (hasIndex) {
            entityIndex = Optional.of(buffer.readInt());
        }
        int amountOfAbilities = buffer.readInt();
        ArrayList<String> abilities = new ArrayList<String>(amountOfAbilities);
        for (int i = 0; i < amountOfAbilities; ++i) {
            abilities.add(buffer.func_218666_n());
        }
        return new MorphPacket(toMorph, entityIndex, morphList, abilities, playerUUID);
    }

    @Override
    public void handle(MorphPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(packet.getPlayer());
            if (player != null) {
                LazyOptional cap = player.getCapability(MorphCapabilityAttacher.MORPH_CAP);
                if (cap.isPresent()) {
                    IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                    resolved.setMorphList(packet.getMorphList());
                }
                MorphUtil.morphToClient(packet.getEntityData(), packet.getEntityIndex(), packet.getAbilities(), player);
            }
        });
    }

    public static class MorphPacket {
        private Optional<MorphItem> entityData;
        private Optional<Integer> entityIndex;
        private MorphList morphList;
        private ArrayList<String> abilities;
        private UUID player;

        public MorphPacket(Optional<MorphItem> entityData, Optional<Integer> entityIndex, MorphList morphList, ArrayList<String> abilities, UUID player) {
            this.entityData = entityData;
            this.player = player;
            this.morphList = morphList;
            this.entityIndex = entityIndex;
            this.abilities = abilities;
        }

        public ArrayList<String> getAbilities() {
            return this.abilities;
        }

        public Optional<MorphItem> getEntityData() {
            return this.entityData;
        }

        public UUID getPlayer() {
            return this.player;
        }

        public MorphList getMorphList() {
            return this.morphList;
        }

        public Optional<Integer> getEntityIndex() {
            return this.entityIndex;
        }
    }
}

