/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MorphChangedSynchronizer
implements ISimpleImplPacket<MorphChangedPacket> {
    @Override
    public void encode(MorphChangedPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.getPlayerUUID());
        buffer.writeBoolean(packet.getMorphIndex().isPresent());
        buffer.writeBoolean(packet.getMorphItem().isPresent());
        packet.getMorphIndex().ifPresent(index -> buffer.writeInt(index.intValue()));
        packet.getMorphItem().ifPresent(item -> buffer.func_150786_a(item.serialize()));
        buffer.writeInt(packet.getAbilities().size());
        for (String str : packet.getAbilities()) {
            buffer.func_180714_a(str);
        }
    }

    @Override
    public MorphChangedPacket decode(PacketBuffer buffer) {
        UUID playerUUID = buffer.func_179253_g();
        boolean hasIndex = buffer.readBoolean();
        boolean hasItem = buffer.readBoolean();
        Optional<Integer> morphIndex = Optional.empty();
        Optional<MorphItem> morphItem = Optional.empty();
        if (hasIndex) {
            morphIndex = Optional.of(buffer.readInt());
        }
        if (hasItem) {
            morphItem = Optional.of(MorphHandler.deserializeMorphItem(buffer.func_150793_b()));
        }
        int amountOfAbilities = buffer.readInt();
        ArrayList<String> abilities = new ArrayList<String>(amountOfAbilities);
        for (int i = 0; i < amountOfAbilities; ++i) {
            abilities.add(buffer.func_218666_n());
        }
        return new MorphChangedPacket(playerUUID, morphIndex, morphItem, abilities);
    }

    @Override
    public void handle(MorphChangedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> MorphUtil.morphToClient(packet.getMorphItem(), packet.getMorphIndex(), packet.getAbilities(), Minecraft.func_71410_x().field_71441_e.func_217371_b(packet.getPlayerUUID())));
    }

    public static class MorphChangedPacket {
        UUID playerUUID;
        Optional<Integer> morphIndex;
        Optional<MorphItem> morphItem;
        ArrayList<String> abilities;

        public MorphChangedPacket(UUID playerUUID, Optional<Integer> morphIndex, Optional<MorphItem> morphItem, ArrayList<String> abilities) {
            this.playerUUID = playerUUID;
            this.morphIndex = morphIndex;
            this.morphItem = morphItem;
            this.abilities = abilities;
        }

        public Optional<Integer> getMorphIndex() {
            return this.morphIndex;
        }

        public Optional<MorphItem> getMorphItem() {
            return this.morphItem;
        }

        public ArrayList<String> getAbilities() {
            return this.abilities;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

