/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;

public class MorphRemovedSynchronizer
implements ISimpleImplPacket<MorphRemovedPacket> {
    @Override
    public void encode(MorphRemovedPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.getPlayerUUID());
        buffer.writeInt(packet.getRemovedMorph());
    }

    @Override
    public MorphRemovedPacket decode(PacketBuffer buffer) {
        return new MorphRemovedPacket(buffer.func_179253_g(), buffer.readInt());
    }

    @Override
    public void handle(MorphRemovedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional cap = Minecraft.func_71410_x().field_71441_e.func_217371_b(packet.getPlayerUUID()).getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                resolved.removeFromMorphList(packet.getRemovedMorph());
            }
        });
    }

    public static class MorphRemovedPacket {
        UUID playerUUID;
        int removedMorph;

        public MorphRemovedPacket(UUID playerUUID, int removedMorph) {
            this.playerUUID = playerUUID;
            this.removedMorph = removedMorph;
        }

        public int getRemovedMorph() {
            return this.removedMorph;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

