/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;

public class MorphRequestMorphIndexChange
implements ISimpleImplPacket<RequestMorphIndexChangePacket> {
    @Override
    public void encode(RequestMorphIndexChangePacket packet, PacketBuffer buffer) {
        buffer.writeInt(packet.requestedIndex);
    }

    @Override
    public RequestMorphIndexChangePacket decode(PacketBuffer buffer) {
        return new RequestMorphIndexChangePacket(buffer.readInt());
    }

    @Override
    public void handle(RequestMorphIndexChangePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional cap = ((NetworkEvent.Context)ctx.get()).getSender().getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (packet.getRequestedIndex() == -1) {
                    MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                } else if (packet.getRequestedIndex() >= resolved.getMorphList().getMorphArrayList().size() || packet.getRequestedIndex() < 0) {
                    System.out.println("Player " + ((NetworkEvent.Context)ctx.get()).getSender().func_200200_C_().getString() + " with UUID " + ((NetworkEvent.Context)ctx.get()).getSender().func_110124_au() + " has tried to send invalid data!");
                } else {
                    boolean shouldMorph;
                    ResourceLocation morphToRS = resolved.getMorphList().getMorphArrayList().get(packet.getRequestedIndex()).getEntityType().getRegistryName();
                    boolean bl = shouldMorph = !ConfigManager.INSTANCE.get(BlacklistData.class).isInBlacklist(morphToRS);
                    if (shouldMorph) {
                        MorphUtil.morphToServer(Optional.empty(), Optional.of(packet.getRequestedIndex()), (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                    } else {
                        ((NetworkEvent.Context)ctx.get()).getSender().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "I'm sorry but you can't morph into " + morphToRS.toString() + " as this entity is currently blacklisted."), Util.field_240973_b_);
                    }
                }
            }
        });
    }

    public static class RequestMorphIndexChangePacket {
        int requestedIndex;

        public RequestMorphIndexChangePacket(int requestedIndex) {
            this.requestedIndex = requestedIndex;
        }

        public int getRequestedIndex() {
            return this.requestedIndex;
        }
    }
}

