/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.render_handler;

import de.budschie.bmorph.api_interact.ShrinkAPIInteractor;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.morph.AdvancedAbstractClientPlayerEntity;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.render_handler.EntitySynchronizerRegistry;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import de.budschie.bmorph.render_handler.InitializeMorphEntityEvent;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    public static WeakHashMap<UUID, Entity> cachedEntities = new WeakHashMap();
    private static boolean lock = false;

    @SubscribeEvent
    public static void onMorphInit(InitializeMorphEntityEvent event) {
        if (event.getPlayer() == Minecraft.func_71410_x().field_71439_g) {
            event.getMorphEntity().func_174805_g(false);
        }
        if (event.getMorphEntity() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity entity = (AbstractClientPlayerEntity)event.getMorphEntity();
            entity.func_184819_a(event.getPlayer().func_184591_cq() == HandSide.LEFT ? HandSide.RIGHT : HandSide.LEFT);
        }
        if (event.getMorphEntity() instanceof AdvancedAbstractClientPlayerEntity) {
            AdvancedAbstractClientPlayerEntity advanced = (AdvancedAbstractClientPlayerEntity)event.getMorphEntity();
            advanced.setIsWearing(part -> event.getPlayer().func_175148_a(part));
        }
        if (event.getMorphEntity() instanceof MobEntity) {
            if (event.getMorphEntity() instanceof AbstractSkeletonEntity) {
                ((MobEntity)event.getMorphEntity()).func_184641_n(event.getPlayer().func_184591_cq() == HandSide.RIGHT);
            } else {
                ((MobEntity)event.getMorphEntity()).func_184641_n(event.getPlayer().func_184591_cq() == HandSide.LEFT);
            }
        }
    }

    public static void checkCache(PlayerEntity player) {
        IMorphCapability capability = (IMorphCapability)player.getCapability(MorphCapabilityAttacher.MORPH_CAP).resolve().get();
        if (cachedEntities.get(player.func_110124_au()) == null || capability.isDirty()) {
            Entity toCache = capability.getCurrentMorph().get().createEntity(player.field_70170_p);
            cachedEntities.put(player.func_110124_au(), toCache);
            capability.cleanDirty();
            MinecraftForge.EVENT_BUS.post((Event)new InitializeMorphEntityEvent(player, toCache));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderedHandler(RenderPlayerEvent.Pre event) {
        Optional<MorphItem> currentMorph;
        LazyOptional morph = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP);
        if (morph.isPresent() && (currentMorph = ((IMorphCapability)morph.resolve().get()).getCurrentMorph()).isPresent()) {
            event.setCanceled(true);
            PlayerEntity player = event.getPlayer();
            RenderHandler.checkCache(player);
            Entity toRender = cachedEntities.get(player.func_110124_au());
            if (toRender == null || ((IMorphCapability)morph.resolve().get()).isDirty()) {
                // empty if block
            }
            if (toRender.field_70170_p != player.field_70170_p) {
                toRender.func_70029_a(toRender.field_70170_p);
            }
            ArrayList<IEntitySynchronizer> list = EntitySynchronizerRegistry.getSynchronizers();
            for (IEntitySynchronizer sync : list) {
                if (!sync.appliesToMorph(toRender)) continue;
                sync.applyToMorphEntity(toRender, player);
            }
            toRender.field_70173_aa = player.field_70173_aa;
            toRender.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            toRender.field_70169_q = player.field_70169_q;
            toRender.field_70167_r = player.field_70167_r;
            toRender.field_70166_s = player.field_70166_s;
            toRender.field_70125_A = player.field_70125_A;
            toRender.field_70177_z = player.field_70177_z;
            toRender.field_70125_A = player.field_70125_A;
            toRender.field_70127_C = player.field_70127_C;
            toRender.field_70177_z = player.field_70177_z;
            toRender.field_70126_B = player.field_70126_B;
            float divisor = ShrinkAPIInteractor.getInteractor().getShrinkingValue(player);
            event.getMatrixStack().func_227860_a_();
            if (ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
                event.getMatrixStack().func_227862_a_(0.81f / divisor, 0.81f / divisor, 0.81f / divisor);
            }
            if (player.func_213453_ef() && ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
                event.getMatrixStack().func_227861_a_(0.0, 1.0, 0.0);
            }
            EntityRenderer manager = Minecraft.func_71410_x().func_175598_ae().func_78713_a(toRender);
            manager.func_225623_a_(toRender, 0.0f, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
            event.getMatrixStack().func_227865_b_();
        }
    }
}

