/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat.client;

import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.util.Bubble;
import com.thomas7520.bubbleschat.util.Message;
import com.thomas7520.bubbleschat.util.ResetUtil;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.opengl.GL11;

public class ClientBubblesUtil {
    public static KeyBinding[] keyBindings = new KeyBinding[1];
    public static final HashMap<UUID, Bubble> BUBBLES_SYNC = new HashMap();
    public static boolean serverSupport = false;
    public static boolean bubbleThroughBlocks;
    private static Color outlineColorConfig;
    private static Color insideColorConfig;
    private static Color textColorConfig;

    public static void registerBindings() {
        ClientBubblesUtil.keyBindings[0] = new KeyBinding("key.openoptions.desc", 48, "key.comicsbubbleschat.category");
        for (KeyBinding keyBinding : keyBindings) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        }
    }

    public static void draw(String text, ArrayDeque<Message> messages, long endTime, float x, float y, float z, boolean isSneaking, boolean drawBubble, boolean drawText, boolean drawLittleBubbles, int bubbleQueue) {
        boolean isThirdPersonFrontal;
        float viewerYaw = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
        float viewerPitch = Minecraft.func_71410_x().func_175598_ae().field_78732_j;
        FontRenderer fontRendererIn = Minecraft.func_71410_x().field_71466_p;
        boolean bl = isThirdPersonFrontal = Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2;
        if (outlineColorConfig == null || insideColorConfig == null || textColorConfig == null) {
            ClientBubblesUtil.updateColors(false);
        }
        Color outlineColor = outlineColorConfig;
        Color insideColor = insideColorConfig;
        Color textColor = textColorConfig;
        long timeLeft = endTime - System.currentTimeMillis();
        if (timeLeft < 0L) {
            throw new IllegalStateException("timeleft cannot be < 0, contact author if you didn't use api");
        }
        if (timeLeft < 3000L) {
            outlineColor = new Color(outlineColorConfig.getRed(), outlineColorConfig.getGreen(), outlineColorConfig.getBlue(), (int)timeLeft * BubblesConfig.client.colorOutline[3] / 3000);
            insideColor = new Color(insideColorConfig.getRed(), insideColorConfig.getGreen(), insideColorConfig.getBlue(), (int)timeLeft * BubblesConfig.client.colorInside[3] / 3000);
            if (timeLeft < 2000L) {
                textColor = new Color(textColorConfig.getRed(), textColorConfig.getGreen(), textColorConfig.getBlue(), (int)timeLeft * BubblesConfig.client.colorText[3] / 2000);
            }
        } else if (outlineColor.getAlpha() < BubblesConfig.client.colorOutline[3]) {
            ClientBubblesUtil.updateColors(false);
        }
        float size = -0.02f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? -1 : 1) * viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        if (!isSneaking && bubbleThroughBlocks) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ArrayList lines = fontRendererIn.func_78271_c(text, 150);
        if (lines.size() >= 5) {
            lines = new ArrayList(fontRendererIn.func_78271_c(text, 250));
        }
        int linesHeight = 10 * lines.size();
        int biggestLineWidth = 0;
        for (String line : lines) {
            int lineWidth = fontRendererIn.func_78256_a(line);
            if (biggestLineWidth >= lineWidth) continue;
            biggestLineWidth = lineWidth;
        }
        float yTranslate = lines.size() + 15;
        int i = biggestLineWidth / 2;
        GlStateManager.func_179090_x();
        GlStateManager.func_179109_b((float)(i + 20), (float)(-yTranslate), (float)0.0f);
        float scale = lines.size() >= 5 ? 1.0f : 1.0f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(lines.size() < 5 ? 0.0f : 0.0f), (float)(lines.size() < 5 ? (float)(-linesHeight) / 2.0f - 15.0f : (float)(-linesHeight) / 2.0f - 15.0f), (float)0.0f);
        if (drawBubble) {
            int distanceBetween = -10;
            int j = 0;
            for (Message value : messages) {
                if (j == bubbleQueue + 1) break;
                String message = value.getMessage();
                ArrayList messageLines = fontRendererIn.func_78271_c(message, 150);
                if (messageLines.size() >= 5) {
                    messageLines = new ArrayList(fontRendererIn.func_78271_c(message, 250));
                }
                distanceBetween = j != bubbleQueue ? (distanceBetween += messageLines.size() * 10 + 4) : (distanceBetween -= messageLines.size());
                ++j;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)(-distanceBetween), (float)0.0f);
            ClientBubblesUtil.drawBubble(i, -linesHeight / 2, outlineColor.getRGB(), insideColor.getRGB());
        }
        if (drawLittleBubbles) {
            ClientBubblesUtil.drawLittleBubble(i, -linesHeight / 2, outlineColor.getRGB(), insideColor.getRGB());
            ClientBubblesUtil.drawMediumBubble(i, -linesHeight / 2, outlineColor.getRGB(), insideColor.getRGB());
        }
        if (drawText) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
            GlStateManager.func_179098_w();
            if (textColor.getAlpha() > 25) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GlStateManager.func_179132_a((boolean)true);
                int lineY = -linesHeight / 2 + 3;
                for (String line : lines) {
                    fontRendererIn.func_78276_b(line, -fontRendererIn.func_78256_a(line) / 2, lineY, textColor.getRGB());
                    lineY = lineY + fontRendererIn.field_78288_b + 1;
                }
            }
            GlStateManager.func_179126_j();
            GL11.glDisable((int)3042);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawBubble(int i, int size, int outlineColor, int insideColor) {
        ClientBubblesUtil.drawRect(-i - 1, size + 1, i + 1, size + 2, outlineColor);
        ClientBubblesUtil.drawRect(-i - 1, -size + 4, i + 1, -size + 5, outlineColor);
        ClientBubblesUtil.drawRect(-i - 1, size + 2, -i - 2, size + 3, outlineColor);
        ClientBubblesUtil.drawRect(-i - 1, -size + 4, -i - 2, -size + 3, outlineColor);
        ClientBubblesUtil.drawRect(-i - 3, size + 3, -i - 2, -size + 3, outlineColor);
        ClientBubblesUtil.drawRect(i + 3, size + 3, i + 2, -size + 3, outlineColor);
        ClientBubblesUtil.drawRect(i + 1, -size + 4, i + 2, -size + 3, outlineColor);
        ClientBubblesUtil.drawRect(i + 1, size + 2, i + 2, size + 3, outlineColor);
        ClientBubblesUtil.drawRect(-i - 1, size + 2, i + 1, -size + 4, insideColor);
        ClientBubblesUtil.drawRect(-i - 2, size + 3, -i - 1, -size + 3, insideColor);
        ClientBubblesUtil.drawRect(i + 2, size + 3, i + 1, -size + 3, insideColor);
    }

    public static void drawMediumBubble(int i, int size, int outlineColor, int insideColor) {
        ClientBubblesUtil.drawRect(-i + 1, -size + 11, -i - 6, -size + 10, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2, -size + 12, -i + 1, -size + 11, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2, -size + 18, -i + 1, -size + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i - 7, -size + 12, -i - 6, -size + 11, outlineColor);
        ClientBubblesUtil.drawRect(-i - 7, -size + 18, -i - 6, -size + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i + 1, -size + 19, -i - 6, -size + 18, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2, -size + 12, -i + 3, -size + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i - 7, -size + 12, -i - 8, -size + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i + 1, -size + 11, -i - 6, -size + 18, insideColor);
        ClientBubblesUtil.drawRect(-i - 7, -size + 12, -i - 6, -size + 17, insideColor);
        ClientBubblesUtil.drawRect(-i + 1, -size + 12, -i + 2, -size + 17, insideColor);
    }

    public static void drawLittleBubble(int i, int size, int outlineColor, int insideColor) {
        ClientBubblesUtil.drawRect(-i + 1 - 11, -size + 11 + 17, -i - 6 - 9, -size + 10 + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2 - 11, -size + 12 + 17, -i - 10, -size + 11 + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2 - 11, -size + 18 + 16, -i - 10, -size + 17 + 16, outlineColor);
        ClientBubblesUtil.drawRect(-i - 7 - 8, -size + 12 + 17, -i - 6 - 10, -size + 11 + 17, outlineColor);
        ClientBubblesUtil.drawRect(-i - 7 - 9, -size + 18 + 16, -i - 5 - 10, -size + 17 + 16, outlineColor);
        ClientBubblesUtil.drawRect(-i + 1 - 11, -size + 19 + 16, -i - 5 - 10, -size + 18 + 16, outlineColor);
        ClientBubblesUtil.drawRect(-i + 2 - 11, -size + 12 + 17, -i + 2 - 10, -size + 17 + 16, outlineColor);
        ClientBubblesUtil.drawRect(-i - 6 - 11, -size + 12 + 17, -i - 6 - 10, -size + 17 + 16, outlineColor);
        ClientBubblesUtil.drawRect(-i + 1 - 11, -size + 11 + 17, -i - 6 - 9, -size + 18 + 16, insideColor);
        ClientBubblesUtil.drawRect(-i - 7 - 9, -size + 12 + 17, -i - 6 - 9, -size + 17 + 16, insideColor);
        ClientBubblesUtil.drawRect(-i + 1 - 11, -size + 12 + 17, -i + 2 - 11, -size + 17 + 16, insideColor);
    }

    public static void updateColors(boolean sync) {
        int[] colorOutline = BubblesConfig.client.colorOutline;
        int[] colorInside = BubblesConfig.client.colorInside;
        int[] colorText = BubblesConfig.client.colorText;
        outlineColorConfig = new Color(colorOutline[0], colorOutline[1], colorOutline[2], colorOutline[3]);
        insideColorConfig = new Color(colorInside[0], colorInside[1], colorInside[2], colorInside[3]);
        textColorConfig = new Color(colorText[0], colorText[1], colorText[2], colorText[3]);
        if (sync) {
            ResetUtil.syncFile();
        }
    }
}

