/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.bubbleschat.packet;

import com.thomas7520.bubbleschat.BubblesConfig;
import com.thomas7520.bubbleschat.client.ClientBubblesUtil;
import com.thomas7520.bubbleschat.util.Bubble;
import com.thomas7520.bubbleschat.util.Message;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SCSyncBubbleMessage
implements IMessage {
    private long startTime;
    private String text;
    private String uuid;

    public SCSyncBubbleMessage(long startTime, String text, String uuid) {
        this.startTime = startTime;
        this.text = text;
        this.uuid = uuid;
    }

    public SCSyncBubbleMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.startTime = buf.readLong();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.startTime);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
    }

    public static class Handler
    implements IMessageHandler<SCSyncBubbleMessage, IMessage> {
        public IMessage onMessage(SCSyncBubbleMessage message, MessageContext ctx) {
            Bubble bubble = ClientBubblesUtil.BUBBLES_SYNC.get(UUID.fromString(message.uuid));
            if (bubble == null) {
                bubble = new Bubble(message.startTime, message.text);
                ClientBubblesUtil.BUBBLES_SYNC.put(UUID.fromString(message.uuid), bubble);
            } else {
                if (bubble.getMessages().size() == BubblesConfig.client.maxBubblesStack) {
                    bubble.getMessages().removeLast();
                }
                bubble.getMessages().addFirst(new Message(message.startTime, message.text));
            }
            return null;
        }
    }
}

