/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CCommandSuggestionHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Style EMPTY_ERROR_STYLE = Style.f_131099_.m_131140_(ChatFormatting.RED);
    private static final Style EMPTY_PASS_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    private static final List<Style> COMMAND_COLOR_STYLES = (List)Stream.of(ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.f_131099_).m_131140_(arg_0)).collect(ImmutableList.toImmutableList());
    private final Minecraft mc;
    private final Screen screen;
    private final EditBox inputField;
    private final Font font;
    private final boolean commandsOnly;
    private final boolean hasCursor;
    private final int minAmountRendered;
    private final int maxAmountRendered;
    private final boolean isChat;
    private final int color;
    private final List<FormattedCharSequence> exceptionList = Lists.newArrayList();
    private int x;
    private int width;
    private ParseResults<SharedSuggestionProvider> parseResults;
    private CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> suggestionsFuture;
    private Suggestions suggestions;
    private boolean autoSuggest;
    private boolean isApplyingSuggestion;
    private int yPos;

    public CCommandSuggestionHelper(Minecraft mc, Screen screen, EditBox inputField, Font font, boolean commandsOnly, boolean hasCursor, int minAmountRendered, int maxAmountRendered, int yPos, int color) {
        this.mc = mc;
        this.screen = screen;
        this.inputField = inputField;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.hasCursor = hasCursor;
        this.minAmountRendered = minAmountRendered;
        this.maxAmountRendered = maxAmountRendered;
        this.isChat = false;
        this.yPos = yPos;
        this.color = color;
        inputField.m_94149_(this::getParsedSuggestion);
    }

    public void shouldAutoSuggest(boolean autoSuggest) {
        this.autoSuggest = autoSuggest;
        if (!autoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions != null && this.suggestions.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screen.m_7222_() == this.inputField && keyCode == 258) {
            this.updateSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean onScroll(double delta) {
        return this.suggestions != null && this.suggestions.onScroll(Mth.m_14008_((double)delta, (double)-1.0, (double)1.0));
    }

    public boolean onClick(double mouseX, double mouseY, int mouseButton) {
        return this.suggestions != null && this.suggestions.onClick((int)mouseX, (int)mouseY, mouseButton);
    }

    public void updateSuggestions(boolean narrateFirstSuggestion) {
        com.mojang.brigadier.suggestion.Suggestions suggestions;
        if (this.suggestionsFuture != null && this.suggestionsFuture.isDone() && !(suggestions = this.suggestionsFuture.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.m_92895_(suggestion.getText()));
            }
            int j = Mth.m_14045_((int)this.inputField.m_94211_(suggestions.getRange().getStart()), (int)0, (int)(this.inputField.m_94211_(0) + this.inputField.m_94210_() - i));
            int k = this.yPos;
            this.suggestions = new Suggestions(j, k, i, this.getSuggestions(suggestions), narrateFirstSuggestion);
        }
    }

    private List<Suggestion> getSuggestions(com.mojang.brigadier.suggestion.Suggestions suggestions) {
        String s = this.inputField.m_94155_().substring(0, this.inputField.m_94207_());
        int i = CCommandSuggestionHelper.getLastWhitespace(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void init() {
        boolean flag;
        String s = this.inputField.m_94155_();
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(s)) {
            this.parseResults = null;
        }
        if (!this.isApplyingSuggestion) {
            this.inputField.m_94167_((String)null);
            this.suggestions = null;
        }
        this.exceptionList.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.inputField.m_94207_();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.mc.f_91074_.f_108617_.m_105146_();
            if (this.parseResults == null) {
                this.parseResults = commanddispatcher.parse(stringreader, (Object)this.mc.f_91074_.f_108617_.m_105137_());
            }
            int n = j = this.hasCursor ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.isApplyingSuggestion)) {
                this.suggestionsFuture = commanddispatcher.getCompletionSuggestions(this.parseResults, i);
                this.suggestionsFuture.thenRun(() -> {
                    if (this.suggestionsFuture.isDone()) {
                        this.recompileSuggestions();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = CCommandSuggestionHelper.getLastWhitespace(s1);
            Collection collection = this.mc.f_91074_.f_108617_.m_105137_().m_5982_();
            this.suggestionsFuture = SharedSuggestionProvider.m_82970_((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWhitespace(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static FormattedCharSequence parseException(CommandSyntaxException exception) {
        Component itextcomponent = ComponentUtils.m_130729_((Message)exception.getRawMessage());
        String s = exception.getContext();
        return s == null ? itextcomponent.m_7532_() : new TranslatableComponent("command.context.parse_error", new Object[]{itextcomponent, exception.getCursor(), s}).m_7532_();
    }

    private void recompileSuggestions() {
        if (this.inputField.m_94207_() == this.inputField.m_94155_().length()) {
            if (this.suggestionsFuture.join().isEmpty() && !this.parseResults.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.parseResults.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)entry.getValue();
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(commandsyntaxexception));
                }
                if (i > 0) {
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.parseResults.getReader().canRead()) {
                this.exceptionList.add(CCommandSuggestionHelper.parseException(Commands.m_82097_(this.parseResults)));
            }
        }
        this.x = 0;
        this.width = this.screen.f_96543_;
        if (this.exceptionList.isEmpty()) {
            this.applyFormattingToCommand(ChatFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.autoSuggest && this.mc.f_91066_.f_92037_) {
            this.updateSuggestions(false);
        }
    }

    private void applyFormattingToCommand(ChatFormatting formatting) {
        CommandContextBuilder commandcontextbuilder = this.parseResults.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.inputField.m_94207_());
        Map map = this.mc.f_91074_.f_108617_.m_105146_().getSmartUsage(suggestioncontext.parent, (Object)this.mc.f_91074_.f_108617_.m_105137_());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        Style style = Style.f_131099_.m_131140_(formatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(FormattedCharSequence.m_13714_((String)((String)entry.getValue()), (Style)style));
            i = Math.max(i, this.font.m_92895_((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.exceptionList.addAll(list);
            this.x = Mth.m_14045_((int)this.inputField.m_94211_(suggestioncontext.startPos), (int)0, (int)(this.inputField.m_94211_(0) + this.inputField.m_94210_() - i));
            this.width = i;
        }
    }

    private FormattedCharSequence getParsedSuggestion(String command, int maxLength) {
        return this.parseResults != null ? CCommandSuggestionHelper.getFinalSuggestion(this.parseResults, command, maxLength) : FormattedCharSequence.m_13714_((String)command, (Style)Style.f_131099_);
    }

    @Nullable
    private static String getMatchedSuggestionText(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    private static FormattedCharSequence getFinalSuggestion(ParseResults<SharedSuggestionProvider> provider, String command, int maxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = provider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= COMMAND_COLOR_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - maxLength, 0)) >= command.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - maxLength, command.length());
            if (l <= 0) continue;
            list.add(FormattedCharSequence.m_13714_((String)command.substring(i, k), (Style)EMPTY_PASS_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)command.substring(k, l), (Style)COMMAND_COLOR_STYLES.get(j)));
            i = l;
        }
        if (provider.getReader().canRead() && (i1 = Math.max(provider.getReader().getCursor() - maxLength, 0)) < command.length()) {
            int j1 = Math.min(i1 + provider.getReader().getRemainingLength(), command.length());
            list.add(FormattedCharSequence.m_13714_((String)command.substring(i, i1), (Style)EMPTY_PASS_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)command.substring(i1, j1), (Style)EMPTY_ERROR_STYLE));
            i = j1;
        }
        list.add(FormattedCharSequence.m_13714_((String)command.substring(i), (Style)EMPTY_PASS_STYLE));
        return FormattedCharSequence.m_13722_((List)list);
    }

    public void drawSuggestionList(PoseStack PoseStack2, int mouseX, int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.drawSuggestions(PoseStack2, mouseX, mouseY);
        } else {
            int i = 0;
            for (FormattedCharSequence FormattedCharSequence2 : this.exceptionList) {
                int j = this.yPos + 12 * i;
                ++i;
            }
        }
    }

    public String getSuggestionMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getCurrentSuggestionMessage() : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Suggestions {
        private final Rect2i suggestionRenderBox;
        private final String originalInputText;
        private final List<Suggestion> suggestions;
        private int lowestDisplayedSuggestionIndex;
        private int selectedIndex;
        private Vec2 lastMousePosition = Vec2.f_82462_;
        private boolean changeSelectionOnNextTabInput;
        private int lastObtainedSuggestionMessageIndex;

        private Suggestions(int x, int y, int width, List<Suggestion> suggestions, boolean narrateFirstSuggestion) {
            int i = x - 1;
            int j = CCommandSuggestionHelper.this.isChat ? y - 3 - Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12 : y;
            this.suggestionRenderBox = new Rect2i(i, j, width + 1, Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12);
            this.originalInputText = CCommandSuggestionHelper.this.inputField.m_94155_();
            this.lastObtainedSuggestionMessageIndex = narrateFirstSuggestion ? -1 : 0;
            this.suggestions = suggestions;
            this.selectSuggestion(0);
        }

        public void drawSuggestions(PoseStack PoseStack2, int mouseX, int mouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered);
            int j = -5592406;
            boolean flag = this.lowestDisplayedSuggestionIndex > 0;
            boolean flag1 = this.suggestions.size() > this.lowestDisplayedSuggestionIndex + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMousePosition.f_82470_ != (float)mouseX || this.lastMousePosition.f_82471_ != (float)mouseY;
            if (flag3) {
                this.lastMousePosition = new Vec2((float)mouseX, (float)mouseY);
            }
            if (flag2) {
                GuiComponent.m_93172_((PoseStack)PoseStack2, (int)this.suggestionRenderBox.m_110085_(), (int)(this.suggestionRenderBox.m_110086_() - 1), (int)(this.suggestionRenderBox.m_110085_() + this.suggestionRenderBox.m_110090_()), (int)this.suggestionRenderBox.m_110086_(), (int)CCommandSuggestionHelper.this.color);
                GuiComponent.m_93172_((PoseStack)PoseStack2, (int)this.suggestionRenderBox.m_110085_(), (int)(this.suggestionRenderBox.m_110086_() + this.suggestionRenderBox.m_110091_()), (int)(this.suggestionRenderBox.m_110085_() + this.suggestionRenderBox.m_110090_()), (int)(this.suggestionRenderBox.m_110086_() + this.suggestionRenderBox.m_110091_() + 1), (int)CCommandSuggestionHelper.this.color);
                if (flag) {
                    for (int k = 0; k < this.suggestionRenderBox.m_110090_(); ++k) {
                        if (k % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)PoseStack2, (int)(this.suggestionRenderBox.m_110085_() + k), (int)(this.suggestionRenderBox.m_110086_() - 1), (int)(this.suggestionRenderBox.m_110085_() + k + 1), (int)this.suggestionRenderBox.m_110086_(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.suggestionRenderBox.m_110090_(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)PoseStack2, (int)(this.suggestionRenderBox.m_110085_() + i1), (int)(this.suggestionRenderBox.m_110086_() + this.suggestionRenderBox.m_110091_()), (int)(this.suggestionRenderBox.m_110085_() + i1 + 1), (int)(this.suggestionRenderBox.m_110086_() + this.suggestionRenderBox.m_110091_() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.get(l + this.lowestDisplayedSuggestionIndex);
                GuiComponent.m_93172_((PoseStack)PoseStack2, (int)this.suggestionRenderBox.m_110085_(), (int)(this.suggestionRenderBox.m_110086_() + 12 * l), (int)(this.suggestionRenderBox.m_110085_() + this.suggestionRenderBox.m_110090_()), (int)(this.suggestionRenderBox.m_110086_() + 12 * l + 12), (int)CCommandSuggestionHelper.this.color);
                if (mouseX > this.suggestionRenderBox.m_110085_() && mouseX < this.suggestionRenderBox.m_110085_() + this.suggestionRenderBox.m_110090_() && mouseY > this.suggestionRenderBox.m_110086_() + 12 * l && mouseY < this.suggestionRenderBox.m_110086_() + 12 * l + 12) {
                    if (flag3) {
                        this.selectSuggestion(l + this.lowestDisplayedSuggestionIndex);
                    }
                    flag4 = true;
                }
                CCommandSuggestionHelper.this.font.m_92750_(PoseStack2, suggestion.getText(), (float)(this.suggestionRenderBox.m_110085_() + 1), (float)(this.suggestionRenderBox.m_110086_() + 2 + 12 * l), l + this.lowestDisplayedSuggestionIndex == this.selectedIndex ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestions.get(this.selectedIndex).getTooltip()) != null) {
                CCommandSuggestionHelper.this.screen.m_96602_(PoseStack2, ComponentUtils.m_130729_((Message)message), mouseX, mouseY);
            }
        }

        public boolean onClick(int mouseX, int mouseY, int mouseButton) {
            if (!this.suggestionRenderBox.m_110087_(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.suggestionRenderBox.m_110086_()) / 12 + this.lowestDisplayedSuggestionIndex;
            if (i >= 0 && i < this.suggestions.size()) {
                this.selectSuggestion(i);
                this.applySuggestionToInput();
            }
            return true;
        }

        public boolean onScroll(double delta) {
            int j;
            int i = (int)(CCommandSuggestionHelper.this.mc.f_91067_.m_91589_() * (double)CCommandSuggestionHelper.this.mc.m_91268_().m_85445_() / (double)CCommandSuggestionHelper.this.mc.m_91268_().m_85443_());
            if (this.suggestionRenderBox.m_110087_(i, j = (int)(CCommandSuggestionHelper.this.mc.f_91067_.m_91594_() * (double)CCommandSuggestionHelper.this.mc.m_91268_().m_85446_() / (double)CCommandSuggestionHelper.this.mc.m_91268_().m_85444_()))) {
                this.lowestDisplayedSuggestionIndex = Mth.m_14045_((int)((int)((double)this.lowestDisplayedSuggestionIndex - delta)), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
                return true;
            }
            return false;
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.changeSelection(-1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 264) {
                this.changeSelection(1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 258) {
                if (this.changeSelectionOnNextTabInput) {
                    this.changeSelection(Screen.m_96638_() ? -1 : 1);
                }
                this.applySuggestionToInput();
                return true;
            }
            if (keyCode == 256) {
                this.clearSuggestions();
                return true;
            }
            return false;
        }

        public void changeSelection(int change) {
            this.selectSuggestion(this.selectedIndex + change);
            int i = this.lowestDisplayedSuggestionIndex;
            int j = this.lowestDisplayedSuggestionIndex + CCommandSuggestionHelper.this.maxAmountRendered - 1;
            if (this.selectedIndex < i) {
                this.lowestDisplayedSuggestionIndex = Mth.m_14045_((int)this.selectedIndex, (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            } else if (this.selectedIndex > j) {
                this.lowestDisplayedSuggestionIndex = Mth.m_14045_((int)(this.selectedIndex + CCommandSuggestionHelper.this.minAmountRendered - CCommandSuggestionHelper.this.maxAmountRendered), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            }
        }

        public void selectSuggestion(int index) {
            this.selectedIndex = index;
            if (this.selectedIndex < 0) {
                this.selectedIndex += this.suggestions.size();
            }
            if (this.selectedIndex >= this.suggestions.size()) {
                this.selectedIndex -= this.suggestions.size();
            }
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.inputField.m_94167_(CCommandSuggestionHelper.getMatchedSuggestionText(CCommandSuggestionHelper.this.inputField.m_94155_(), suggestion.apply(this.originalInputText)));
            if (NarratorChatListener.f_93311_.m_93316_() && this.lastObtainedSuggestionMessageIndex != this.selectedIndex) {
                NarratorChatListener.f_93311_.m_168785_(this.getCurrentSuggestionMessage());
            }
        }

        public void applySuggestionToInput() {
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = true;
            CCommandSuggestionHelper.this.inputField.m_94144_(suggestion.apply(this.originalInputText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            CCommandSuggestionHelper.this.inputField.m_94196_(i);
            CCommandSuggestionHelper.this.inputField.m_94208_(i);
            this.selectSuggestion(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = false;
            this.changeSelectionOnNextTabInput = true;
        }

        private Component getCurrentSuggestionMessage() {
            this.lastObtainedSuggestionMessageIndex = this.selectedIndex;
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            Message message = suggestion.getTooltip();
            return message != null ? new TranslatableComponent("narration.suggestion.tooltip", new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText(), message.getString()}) : new TranslatableComponent("narration.suggestion", new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText()});
        }

        public void clearSuggestions() {
            CCommandSuggestionHelper.this.suggestions = null;
        }
    }
}

