/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.namensammler.cosmicnpcs.client.renderer.entity.CustomLivingRenderer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CAbstractEyesLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CCatCollarLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CDrownedOuterLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CEnergyLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CHeldBlockLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLeatherHorseArmorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLlamaDecorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CMooshroomMushroomLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CPlayerItemInHandLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSaddleLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSheepWoolLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSlimeGelLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSnowmanHeadLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CStrayClothingLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CVillagerLevelPendantLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CWolfCollarLayer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.MushroomCowRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.SnowGolemRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.WitherBossRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.layers.CarriedBlockLayer;
import net.minecraft.client.renderer.entity.layers.CatCollarLayer;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.EnderEyesLayer;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.LlamaDecorLayer;
import net.minecraft.client.renderer.entity.layers.MushroomCowMushroomLayer;
import net.minecraft.client.renderer.entity.layers.PhantomEyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.client.renderer.entity.layers.SheepFurLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.entity.layers.SnowGolemHeadLayer;
import net.minecraft.client.renderer.entity.layers.SpiderEyesLayer;
import net.minecraft.client.renderer.entity.layers.StrayClothingLayer;
import net.minecraft.client.renderer.entity.layers.VillagerProfessionLayer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.entity.layers.WolfCollarLayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CosmicNPCRenderer
extends LivingEntityRenderer<CosmicNPCEntity, PlayerModel<CosmicNPCEntity>> {
    private Map<String, CustomLivingRenderer> modelRenderers = new HashMap<String, CustomLivingRenderer>();
    private static PlayerModel player_model;
    private static PlayerModel player_model_slim;
    private static final ResourceLocation STEVE_TEXTURE;
    private static final ResourceLocation ALEX_TEXTURE;
    private static EntityRendererProvider.Context renderContext;

    public CosmicNPCRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext, (EntityModel)new PlayerModel(renderContext.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        player_model = new PlayerModel(renderContext.m_174023_(ModelLayers.f_171162_), false);
        player_model_slim = new PlayerModel(renderContext.m_174023_(ModelLayers.f_171166_), true);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(renderContext.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(renderContext.m_174023_(ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new CPlayerItemInHandLayer(this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderContext.m_174027_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, renderContext.m_174027_()));
        CosmicNPCRenderer.renderContext = renderContext;
    }

    protected void scale(CosmicNPCEntity entitylivingbaseIn, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    public ResourceLocation getTextureLocation(CosmicNPCEntity npc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + npc.getTextureName() + ".png");
        if (npc.getTextureName() != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/main/" + npc.getTextureName() + ".png");
        }
        return npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim")) ? ALEX_TEXTURE : STEVE_TEXTURE;
    }

    public void render(CosmicNPCEntity npc, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            this.f_115290_ = player_model_slim;
            this.f_114477_ = 0.5f;
            this.setModelProperties(npc);
            super.m_7392_((LivingEntity)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player"))) {
            this.f_115290_ = player_model;
            this.f_114477_ = 0.5f;
            this.setModelProperties(npc);
            super.m_7392_((LivingEntity)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else {
            EntityType.m_20632_((String)npc.getModel().toString()).ifPresent(entityType -> {
                if (entityType.m_20615_(npc.f_19853_) instanceof LivingEntity) {
                    LivingEntity modelEntity = (LivingEntity)entityType.m_20615_(npc.f_19853_);
                    if (this.f_114476_.m_114382_((Entity)(modelEntity = this.copyEntityData(modelEntity, npc))) instanceof LivingEntityRenderer) {
                        LivingEntityRenderer modelEntityRenderer = (LivingEntityRenderer)this.f_114476_.m_114382_((Entity)modelEntity);
                        EntityModel model = modelEntityRenderer.m_7200_();
                        if (!this.modelRenderers.containsKey(npc.getTextureName() + npc.getModel().toString() + npc.getSettings().toString())) {
                            this.modelRenderers.put(npc.getTextureName() + npc.getModel().toString() + npc.getSettings().toString(), new CustomLivingRenderer(renderContext, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)modelEntityRenderer, npc, this.getLayers(modelEntityRenderer, npc)));
                        } else {
                            CustomLivingRenderer customRenderer = this.modelRenderers.get(npc.getTextureName() + npc.getModel().toString() + npc.getSettings().toString());
                            this.f_114477_ = customRenderer.modelShadowSize;
                            if (npc.getSettings().m_128471_("IsChild")) {
                                this.f_114477_ *= 0.5f;
                            }
                            customRenderer.m_7392_(modelEntity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                        }
                    }
                }
            });
        }
    }

    private LivingEntity copyEntityData(LivingEntity modelEntity, CosmicNPCEntity npc) {
        modelEntity.f_20912_ = npc.f_20912_;
        modelEntity.f_20921_ = npc.f_20921_;
        modelEntity.f_20920_ = npc.f_20920_;
        modelEntity.f_19797_ = npc.f_19797_;
        modelEntity.m_20234_(npc.m_142049_());
        modelEntity.m_19890_(npc.m_20185_(), npc.m_20186_(), npc.m_20189_(), npc.m_146908_(), npc.m_146909_());
        modelEntity.f_19859_ = npc.f_19859_;
        modelEntity.f_19860_ = npc.f_19860_;
        modelEntity.f_20885_ = npc.f_20885_;
        modelEntity.f_20886_ = npc.f_20886_;
        modelEntity.f_20883_ = npc.f_20883_;
        modelEntity.f_20884_ = npc.f_20884_;
        modelEntity.f_20925_ = npc.f_20925_;
        modelEntity.f_20924_ = npc.f_20924_;
        modelEntity.f_20923_ = npc.f_20923_;
        modelEntity.f_20916_ = npc.f_20916_;
        modelEntity.m_8061_(EquipmentSlot.MAINHAND, npc.m_21205_());
        modelEntity.m_8061_(EquipmentSlot.OFFHAND, npc.m_21206_());
        modelEntity.m_8061_(EquipmentSlot.HEAD, npc.m_6844_(EquipmentSlot.HEAD));
        modelEntity.m_8061_(EquipmentSlot.CHEST, npc.m_6844_(EquipmentSlot.CHEST));
        modelEntity.m_8061_(EquipmentSlot.LEGS, npc.m_6844_(EquipmentSlot.LEGS));
        modelEntity.m_8061_(EquipmentSlot.FEET, npc.m_6844_(EquipmentSlot.FEET));
        modelEntity.m_20124_(npc.m_20089_());
        modelEntity.m_20260_(npc.m_6144_());
        modelEntity.m_6593_(npc.m_7770_());
        modelEntity.m_20340_(npc.m_20151_());
        modelEntity.m_6842_(npc.m_20145_());
        VillagerType type = (VillagerType)Registry.f_122868_.m_7745_(new ResourceLocation(npc.getSettings().m_128461_("VillagerType")));
        VillagerProfession profession = Registry.f_122869_.m_6612_(new ResourceLocation(npc.getSettings().m_128461_("Profession"))).orElse(VillagerProfession.f_35586_);
        int profLevel = npc.getSettings().m_128451_("ProfessionLevel");
        if (npc.getSettings().m_128461_("Profession").equals("default") && npc.getSettings().m_128461_("ProfessionLevel").equals("default")) {
            profession = VillagerProfession.f_35585_;
        }
        VillagerData data = new VillagerData(type, profession, profLevel);
        if (modelEntity instanceof Villager) {
            Villager villager = (Villager)modelEntity;
            villager.m_141967_(data);
            villager.m_6863_(npc.getSettings().m_128471_("IsChild"));
            return villager;
        }
        if (modelEntity instanceof ZombieVillager) {
            ZombieVillager zVillager = (ZombieVillager)modelEntity;
            zVillager.m_141967_(data);
            return zVillager;
        }
        if (modelEntity instanceof EnderMan) {
            EnderMan enderman = (EnderMan)modelEntity;
            enderman.m_32521_(null);
            return enderman;
        }
        if (modelEntity instanceof Mob) {
            Mob mobEntity = (Mob)modelEntity;
            mobEntity.m_6863_(npc.getSettings().m_128471_("IsChild"));
            if (npc.m_21205_().m_41720_() instanceof BowItem && npc.m_6117_()) {
                mobEntity.m_21561_(true);
            }
            return mobEntity;
        }
        return modelEntity;
    }

    private List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> getLayers(LivingEntityRenderer renderer, CosmicNPCEntity npc) {
        List layerRenderers = Lists.newArrayList();
        ArrayList newLayerRenderers = Lists.newArrayList();
        try {
            Field layerRenderersField = null;
            layerRenderersField = ObfuscationReflectionHelper.findField(LivingEntityRenderer.class, (String)"f_115291_");
            layerRenderersField.setAccessible(true);
            layerRenderers = (List)layerRenderersField.get(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < layerRenderers.size(); ++i) {
            SnowGolemRenderer snowmanRenderer;
            EndermanRenderer endermanRenderer;
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(VillagerProfessionLayer.class)) {
                newLayerRenderers.add(new CVillagerLevelPendantLayer(renderer, (ReloadableResourceManager)Minecraft.m_91087_().m_91098_(), "villager", npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SheepFurLayer.class)) {
                SheepRenderer sheepRenderer = (SheepRenderer)renderer;
                newLayerRenderers.add(new CSheepWoolLayer(sheepRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(EnderEyesLayer.class)) {
                endermanRenderer = (EndermanRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(endermanRenderer, npc, CAbstractEyesLayer.EyeType.ENDERMAN));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SpiderEyesLayer.class)) {
                SpiderRenderer spiderRenderer = (SpiderRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(spiderRenderer, npc, CAbstractEyesLayer.EyeType.SPIDER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(PhantomEyesLayer.class)) {
                PhantomRenderer phantomRenderer = (PhantomRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(phantomRenderer, npc, CAbstractEyesLayer.EyeType.PHANTOM));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(StrayClothingLayer.class)) {
                StrayRenderer strayRenderer = (StrayRenderer)renderer;
                newLayerRenderers.add(new CStrayClothingLayer(strayRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(DrownedOuterLayer.class)) {
                DrownedRenderer drownedRenderer = (DrownedRenderer)renderer;
                newLayerRenderers.add(new CDrownedOuterLayer(drownedRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(MushroomCowMushroomLayer.class)) {
                MushroomCowRenderer mooshroomRenderer = (MushroomCowRenderer)renderer;
                newLayerRenderers.add(new CMooshroomMushroomLayer(mooshroomRenderer, npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(LlamaDecorLayer.class)) {
                LlamaRenderer llamaRenderer = (LlamaRenderer)renderer;
                newLayerRenderers.add(new CLlamaDecorLayer((RenderLayerParent<Llama, LlamaModel<Llama>>)llamaRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(CatCollarLayer.class)) {
                CatRenderer catRenderer = (CatRenderer)renderer;
                newLayerRenderers.add(new CCatCollarLayer((RenderLayerParent<Cat, CatModel<Cat>>)catRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(CreeperPowerLayer.class)) {
                CreeperRenderer creeperRenderer = (CreeperRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(creeperRenderer, renderContext.m_174027_(), npc, CEnergyLayer.Type.CREEPER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(WitherArmorLayer.class)) {
                WitherBossRenderer witherRenderer = (WitherBossRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(witherRenderer, renderContext.m_174027_(), npc, CEnergyLayer.Type.WITHER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(HorseArmorLayer.class)) {
                HorseRenderer horseRenderer = (HorseRenderer)renderer;
                newLayerRenderers.add(new CLeatherHorseArmorLayer((RenderLayerParent<Horse, HorseModel<Horse>>)horseRenderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SaddleLayer.class)) {
                if (renderer instanceof StriderRenderer) {
                    newLayerRenderers.add(new CSaddleLayer(renderer, renderer.m_7200_(), new ResourceLocation("textures/entity/strider/strider_saddle.png"), npc));
                    continue;
                }
                newLayerRenderers.add(new CSaddleLayer(renderer, renderer.m_7200_(), new ResourceLocation("textures/entity/pig/pig_saddle.png"), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SlimeOuterLayer.class)) {
                newLayerRenderers.add(new CSlimeGelLayer(renderer, renderContext.m_174027_(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SnowGolemHeadLayer.class)) {
                snowmanRenderer = (SnowGolemRenderer)renderer;
                newLayerRenderers.add(new CSnowmanHeadLayer((RenderLayerParent<SnowGolem, SnowGolemModel<SnowGolem>>)snowmanRenderer, npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(WolfCollarLayer.class)) {
                snowmanRenderer = (WolfRenderer)renderer;
                newLayerRenderers.add(new CWolfCollarLayer((RenderLayerParent<Wolf, WolfModel<Wolf>>)snowmanRenderer, npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(CarriedBlockLayer.class)) {
                endermanRenderer = (EndermanRenderer)renderer;
                newLayerRenderers.add(new CHeldBlockLayer(endermanRenderer));
                continue;
            }
            newLayerRenderers.add((RenderLayer)layerRenderers.get(i));
        }
        return newLayerRenderers;
    }

    private float getShadowSize(LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        float shadowSize = 0.5f;
        try {
            Field shadowSizeField = null;
            shadowSizeField = ObfuscationReflectionHelper.findField(EntityRenderer.class, (String)"f_114477_");
            shadowSizeField.setAccessible(true);
            shadowSize = shadowSizeField.getFloat(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        return shadowSize;
    }

    private void setModelProperties(CosmicNPCEntity p_117819_) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        if (p_117819_.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102817_ = p_117819_.m_6047_();
            HumanoidModel.ArmPose humanoidmodel$armpose = CosmicNPCRenderer.getArmPose(p_117819_, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = CosmicNPCRenderer.getArmPose(p_117819_, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = p_117819_.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (p_117819_.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = humanoidmodel$armpose;
                playermodel.f_102815_ = humanoidmodel$armpose1;
            } else {
                playermodel.f_102816_ = humanoidmodel$armpose1;
                playermodel.f_102815_ = humanoidmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(CosmicNPCEntity player, InteractionHand handSide) {
        ItemStack itemstack = player.m_21120_(handSide);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.m_7655_() == handSide && player.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && handSide == player.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!player.f_20911_ && itemstack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void setupRotations(CosmicNPCEntity p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.m_20998_(p_117806_);
        if (p_117802_.m_21255_()) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                p_117803_.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                p_117803_.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.m_20069_() ? -90.0f - p_117802_.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            p_117803_.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            if (p_117802_.m_6067_()) {
                p_117803_.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }

    protected boolean shouldShowName(CosmicNPCEntity entity) {
        return super.m_6512_((LivingEntity)entity) && (entity.m_6052_() || entity.m_8077_() && entity == this.f_114476_.f_114359_);
    }

    static {
        STEVE_TEXTURE = new ResourceLocation("textures/entity/steve.png");
        ALEX_TEXTURE = new ResourceLocation("textures/entity/alex.png");
    }
}

