/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.events;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.IOException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmicnpcs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        List<NPCAction> aList;
        if (!event.getWorld().f_46443_ && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(9);
            ma.xCoord = event.getPos().m_123341_();
            ma.yCoord = event.getPos().m_123342_();
            ma.zCoord = event.getPos().m_123343_();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        List<NPCAction> aList;
        if (!event.getWorld().m_5776_() && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(8);
            ma.xCoord = event.getPos().m_123341_();
            ma.yCoord = event.getPos().m_123342_();
            ma.zCoord = event.getPos().m_123343_();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        List<NPCAction> aList;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!event.getWorld().m_5776_() && (aList = CosmicNPCs.instance.getActionListForPlayer((Player)event.getEntity())) != null) {
            BlockEntity blockEntity;
            NPCAction ma = new NPCAction(7);
            Block block = event.getPlacedBlock().m_60734_();
            ma.stateId = Block.m_49956_((BlockState)event.getPlacedBlock());
            ma.xCoord = event.getPos().m_123341_();
            ma.yCoord = event.getPos().m_123342_();
            ma.zCoord = event.getPos().m_123343_();
            if (block instanceof SignBlock && (blockEntity = event.getWorld().m_7702_(event.getPos())) instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                ma.itemData = sign.m_5995_();
            }
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getWorld().f_46443_ && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(5);
            ma.arrowCharge = event.getCharge();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getPlayer().f_19853_.f_46443_ && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(3);
            event.getEntityItem().m_32055_().m_41739_(ma.itemData);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onServerChatEvent(ServerChatEvent event) {
        List<NPCAction> aList;
        if (!event.getPlayer().f_19853_.f_46443_ && (aList = CosmicNPCs.instance.getActionListForPlayer((Player)event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(1);
            ma.message = event.getMessage();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onGuiClosing(PlayerContainerEvent.Close event) {
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer());
        if (aList != null) {
            NPCAction ma = new NPCAction(10);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        List<NPCAction> aList;
        if (!event.getWorld().f_46443_ && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(11);
            ma.handType = event.getHand();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            if (!(event.getEntityLiving() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntityLiving();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(12);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            if (!(event.getEntityLiving() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntityLiving();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(13);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        if (!(((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81373_() instanceof Player)) {
            return;
        }
        Player player = (Player)((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81373_();
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
        if (aList != null) {
            NPCAction ma = new NPCAction(14);
            ma.message = event.getParseResults().getReader().getString();
            aList.add(ma);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        CosmicNPCs.safeCommandData();
    }
}

