/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs;

import de.namensammler.cosmicnpcs.common.command.argument.CComponentArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntityArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.core.init.ConfigInit;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.init.KeybindsInit;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCFolderPack;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cosmicnpcs")
public class CosmicNPCs {
    public static CosmicNPCs instance;
    public static final Logger LOGGER;
    public static final String MODID = "cosmicnpcs";
    public static String[] storedCommands;
    public static int commandCounter;
    public Map<Player, NPCRecorder> recordThreads = Collections.synchronizedMap(new HashMap());

    public CosmicNPCs() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityTypesInit.ENTITY_TYPES.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CosmicNPCs.injectCustomResourcePack());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerEntityRenderers);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigInit.common_config);
        ConfigInit.loadConfig(ConfigInit.common_config, FMLPaths.CONFIGDIR.get().resolve("cosmicnpcs-common.toml").toString());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ArgumentTypes.m_121601_((String)"centity_summon", CEntitySummonArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(CEntitySummonArgument::entitySummon));
        ArgumentTypes.m_121601_((String)"centity", CEntityArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(CEntityArgument::entity));
        ArgumentTypes.m_121601_((String)"ccomponent", CComponentArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(CComponentArgument::textComponent));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        KeybindsInit.register(event);
        CosmicNPCs.loadCommandData();
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        EntityTypesInit.registerAttributes(event);
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityTypesInit.registerEntityRenderers(event);
    }

    public static void safeCommandData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("counter", commandCounter);
        data.m_128365_("commands", (Tag)new CompoundTag());
        for (int i = 0; i < storedCommands.length; ++i) {
            if (storedCommands[i] == null) continue;
            data.m_128469_("commands").m_128359_("cmd_" + i, storedCommands[i]);
        }
        File file = new File("config/cosmicnpcs/commands.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            NbtIo.m_128947_((CompoundTag)data, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
    }

    public static void loadCommandData() {
        CompoundTag data = new CompoundTag();
        try {
            data = NbtIo.m_128937_((File)new File("config/cosmicnpcs/commands.dat"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
        if (data.m_128451_("counter") != 0) {
            commandCounter = data.m_128451_("counter");
        }
        for (int i = 0; i < 99; ++i) {
            CosmicNPCs.storedCommands[i] = data.m_128469_("commands").m_128461_("cmd_" + i);
        }
    }

    public List<NPCAction> getActionListForPlayer(Player ep) {
        NPCRecorder aRecorder = this.recordThreads.get(ep);
        if (aRecorder == null) {
            return null;
        }
        return aRecorder.eventsList;
    }

    public void broadcastMsg(String msg) {
        List temp = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        for (ServerPlayer player : temp) {
            TextComponent cmp = new TextComponent("[CosmicNPCs]: " + msg);
            player.m_6352_((Component)cmp, Util.f_137441_);
        }
    }

    public static void injectCustomResourcePack() {
        String path = "config/cosmicnpcs/resources";
        new File(path + "/textures/main").mkdirs();
        new File(path + "/textures/layers").mkdirs();
        NPCFolderPack pack = new NPCFolderPack(new File(path));
        Minecraft.m_91087_().m_91099_().addPackFinder(new RepositorySource((PackResources)pack){
            final /* synthetic */ PackResources val$pack;
            {
                this.val$pack = packResources;
            }

            public void m_7686_(Consumer<Pack> infoConsumer, Pack.PackConstructor infoFactory) {
                infoConsumer.accept(new Pack("npctextures", true, () -> this.val$pack, (Component)new TextComponent("NPC Resources"), (Component)new TextComponent("NPC Resources from the config folder"), PackCompatibility.COMPATIBLE, Pack.Position.BOTTOM, true, text -> text, true));
            }
        });
    }

    static {
        LOGGER = LogManager.getLogger();
        storedCommands = new String[99];
        commandCounter = 1;
    }
}

