/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CSheepWoolLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    private final SheepFurModel sheepModel;
    private String layerTexture;
    private String color;
    private boolean sheared;

    public CSheepWoolLayer(RenderLayerParent<T, M> rendererIn, EntityModelSet modelSet, CosmicNPCEntity npc) {
        super(rendererIn);
        this.sheepModel = new SheepFurModel(modelSet.m_171103_(ModelLayers.f_171178_));
        this.layerTexture = npc.getSettings().m_128461_("Layer");
        this.color = npc.getSettings().m_128461_("Color");
        this.sheared = npc.getSettings().m_128471_("Sheared");
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.sheared && !entitylivingbaseIn.m_20145_()) {
            float f2;
            float f1;
            float f;
            if (entitylivingbaseIn.m_8077_() && "jeb_".equals(entitylivingbaseIn.m_7755_().m_6111_()) || this.color.toLowerCase().equals("rainbow")) {
                int i1 = 25;
                int i = ((LivingEntity)entitylivingbaseIn).f_19797_ / 25 + entitylivingbaseIn.m_142049_();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f3 = ((float)(((LivingEntity)entitylivingbaseIn).f_19797_ % 25) + partialTicks) / 25.0f;
                float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
                f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
                f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            } else {
                float[] afloat = Sheep.m_29829_((DyeColor)((Sheep)entitylivingbaseIn).m_29874_());
                for (DyeColor dyeColor : DyeColor.values()) {
                    if (!dyeColor.m_41065_().equals(this.color)) continue;
                    afloat = Sheep.m_29829_((DyeColor)dyeColor);
                }
                f = afloat[0];
                f1 = afloat[1];
                f2 = afloat[2];
            }
            CSheepWoolLayer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)this.sheepModel, (ResourceLocation)this.getLayerTexture(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)f, (float)f1, (float)f2);
        }
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return TEXTURE;
    }
}

