/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.core.CCAPJson;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayTickThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;

public class CCAPCommand {
    public CCAPCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ccap").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"generate-json").then(Commands.m_82129_((String)"rec-file", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.REC_FILES).executes(command -> this.generateJson((CommandContext<CommandSourceStack>)command)))));
    }

    public int generateJson(CommandContext<CommandSourceStack> context) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String fileName = StringArgumentType.getString(context, (String)"rec-file");
        File file = PlayTickThread.getRecFile((Level)((CommandSourceStack)context.getSource()).m_81372_(), fileName);
        if (!file.exists()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Can't find " + fileName + ".ccap file!"));
            return 1;
        }
        String filePath = file.getPath().concat(".json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), new OpenOption[0]);
            CCAPJson ccapJson = new CCAPJson();
            PlayTickThread player = new PlayTickThread((Level)((CommandSourceStack)context.getSource()).m_81372_(), StringArgumentType.getString(context, (String)"rec-file"));
            player.readRecFile(Integer.MAX_VALUE);
            player.in.close();
            for (NPCAction action : player.ccapData.actionList) {
                if (action.type == 1) {
                    List<CCAPJson.Message> list = ccapJson.chatMessages;
                    CCAPJson cCAPJson = ccapJson;
                    Objects.requireNonNull(cCAPJson);
                    list.add(cCAPJson.new CCAPJson.Message(action.timeStamp, action.message));
                }
                if (action.type != 14) continue;
                List<CCAPJson.Message> list = ccapJson.commands;
                CCAPJson cCAPJson = ccapJson;
                Objects.requireNonNull(cCAPJson);
                list.add(cCAPJson.new CCAPJson.Message(action.timeStamp, action.message));
            }
            ccapJson.duration = (int)player.ticks;
            gson.toJson((Object)ccapJson, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

