/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.CComponentArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.init.ConfigInit;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayTickThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class NPCPlayCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"npc-play").requires(sender -> sender.m_6761_(2))).then(Commands.m_82129_((String)"file", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.REC_FILES).then(Commands.m_82129_((String)"name", (ArgumentType)CComponentArgument.textComponent()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), CComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), new ResourceLocation("minecraft:player"), new CompoundTag(), (CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), CComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSourceStack>)context, "model"), new CompoundTag(), (CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"settings", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), CComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<CommandSourceStack>)context, "model"), CompoundTagArgument.m_87660_((CommandContext)context, (String)"settings"), (CommandSourceStack)context.getSource())))))));
    }

    private static int play(String fileNameIn, Component npcName, String textureName, ResourceLocation model, CompoundTag compound, CommandSourceStack source) {
        File file = PlayTickThread.getRecFile((Level)source.m_81372_(), fileNameIn);
        if (!file.exists()) {
            source.m_81352_((Component)new TextComponent("Can't find " + fileNameIn + ".ccap file!"));
            return 0;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yawHead = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            int compatibility = PlayTickThread.getCompatibility(magic);
            if (compatibility == 0) {
                in.close();
                source.m_81352_((Component)new TextComponent(fileNameIn + ".ccap isn't compatible with this mod version. (" + magic + ")"));
            } else if (compatibility == -1) {
                in.close();
                source.m_81352_((Component)new TextComponent(fileNameIn + " isn't a .ccap file."));
            }
            yawHead = in.readFloat();
            yaw = in.readFloat();
            pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServerLevel world = source.m_81372_();
        CosmicNPCEntity npc = (CosmicNPCEntity)((EntityType)EntityTypesInit.COSMIC_NPC.get()).m_20615_((Level)world);
        boolean isPlayerModel = false;
        if (model.equals((Object)new ResourceLocation("minecraft:player")) || model.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            isPlayerModel = true;
        }
        CompoundTag settings = npc.getSettings();
        settings.m_128405_("ShowNameTag", compound.m_128441_("ShowNameTag") ? compound.m_128451_("ShowNameTag") : (isPlayerModel ? (Integer)ConfigInit.showPlayerNameTags.get() : (Integer)ConfigInit.showMobNameTags.get()).intValue());
        settings.m_128379_("Invulnerable", compound.m_128441_("Invulnerable") ? compound.m_128471_("Invulnerable") : ((Boolean)ConfigInit.invulnerable.get()).booleanValue());
        settings.m_128379_("UseCommands", compound.m_128441_("UseCommands") ? compound.m_128471_("UseCommands") : ((Boolean)ConfigInit.canUseCommands.get()).booleanValue());
        settings.m_128379_("IsChild", compound.m_128441_("IsChild") ? compound.m_128471_("IsChild") : false);
        settings.m_128359_("Layer", compound.m_128441_("Layer") ? compound.m_128461_("Layer").toLowerCase(Locale.ROOT) : "default");
        settings.m_128379_("PickupItems", compound.m_128441_("PickupItems") ? compound.m_128471_("PickupItems") : ((Boolean)ConfigInit.canPickupItems.get()).booleanValue());
        settings.m_128359_("Tag", compound.m_128441_("Tag") ? compound.m_128461_("Tag") : "");
        settings.m_128347_("Health", compound.m_128441_("Health") ? compound.m_128459_("Health") : ((Double)ConfigInit.maxHealth.get()).doubleValue());
        settings.m_128379_("CanDrown", compound.m_128441_("CanDrown") ? compound.m_128471_("CanDrown") : ((Boolean)ConfigInit.canDrown.get()).booleanValue());
        settings.m_128379_("FireDamage", compound.m_128441_("FireDamage") ? compound.m_128471_("FireDamage") : ((Boolean)ConfigInit.takesFireDamage.get()).booleanValue());
        settings.m_128379_("WaterSensitive", compound.m_128441_("WaterSensitive") ? compound.m_128471_("WaterSensitive") : ((Boolean)ConfigInit.takesWaterDamage.get()).booleanValue());
        settings.m_128379_("FallDamage", compound.m_128441_("FallDamage") ? compound.m_128471_("FallDamage") : ((Boolean)ConfigInit.takesFallDamage.get()).booleanValue());
        settings.m_128379_("Loop", compound.m_128441_("Loop") ? compound.m_128471_("Loop") : ((Boolean)ConfigInit.loop.get()).booleanValue());
        settings.m_128379_("ShouldPersist", compound.m_128441_("ShouldPersist") ? compound.m_128471_("ShouldPersist") : ((Boolean)ConfigInit.shouldPersist.get()).booleanValue());
        settings.m_128359_("ChatPrefix", compound.m_128441_("ChatPrefix") ? compound.m_128461_("ChatPrefix") : (String)ConfigInit.chatPrefix.get());
        settings.m_128365_("EntityData", (Tag)(compound.m_128441_("EntityData") ? compound.m_128469_("EntityData") : new CompoundTag()));
        settings.m_128359_("Color", compound.m_128441_("Color") ? compound.m_128461_("Color") : "default");
        settings.m_128359_("MushroomBlock", compound.m_128441_("MushroomBlock") ? compound.m_128461_("MushroomBlock") : "default");
        settings.m_128379_("Charged", compound.m_128441_("Charged") ? compound.m_128471_("Charged") : false);
        settings.m_128359_("Armor", compound.m_128441_("Armor") ? compound.m_128461_("Armor") : "default");
        settings.m_128359_("Head", compound.m_128441_("Head") ? compound.m_128461_("Head") : "default");
        npc.m_6034_(x, y, z);
        npc.f_20885_ = yawHead;
        npc.m_146922_(yaw);
        npc.m_146926_(pitch);
        npc.setNPCName(npcName);
        npc.setTextureName(textureName);
        npc.setModel(model);
        npc.setSettings(settings);
        if (settings.m_128451_("ShowNameTag") >= 1) {
            npc.m_6593_(npc.getNPCName());
        } else {
            npc.m_6593_((Component)((BaseComponent)null));
        }
        if (settings.m_128451_("ShowNameTag") == 1) {
            npc.m_20340_(true);
        } else {
            npc.m_20340_(false);
        }
        npc.m_20331_(settings.m_128471_("Invulnerable"));
        npc.m_20049_(settings.m_128461_("Tag"));
        npc.m_21051_(Attributes.f_22276_).m_22100_(settings.m_128459_("Health"));
        if (npc.m_21233_() < npc.m_21223_()) {
            npc.m_21153_(npc.m_21233_());
        }
        world.m_7967_((Entity)npc);
        npc.getReplayData().m_128359_("CurrentReplay", fileNameIn);
        npc.isReplayActive = true;
        PlayTickThread.register(new PlayTickThread(npc, fileNameIn).fromBeginning());
        return 1;
    }
}

