/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class SuggestionProviders {
    public static final SuggestionProvider<CommandSourceStack> REC_FILES = (context, builder) -> {
        File recFolder;
        Path path = ((CommandSourceStack)context.getSource()).m_81372_().m_142572_().m_129843_(new LevelResource("cosmicnpcs/recordings"));
        String command = context.getInput();
        String fileArgument = command.substring(command.indexOf(" ") + 1);
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<File> files1 = new ArrayList<File>();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            for (File file : SuggestionProviders.getAllFiles(files1, path.toFile())) {
                int index = file.getPath().indexOf("recordings") + 11;
                Object fileName = file.getPath().substring(index).replaceAll(".ccap", "").replaceAll(".json", "");
                if (((String)fileName).contains("/")) {
                    fileName = "'" + (String)fileName + "'";
                }
                files.add((String)fileName);
            }
        }
        if (!(recFolder = new File("" + path)).exists()) {
            recFolder.mkdirs();
        }
        return SharedSuggestionProvider.m_82970_(files, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> TEXTURE_FILES = (context, builder) -> {
        File recFolder = new File("config/cosmicnpcs/resources/textures/main");
        if (!recFolder.exists()) {
            recFolder.mkdir();
        }
        String[] filenames = recFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".png");
            }
        });
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = filenames[i].replaceAll(".png", "");
        }
        ArrayList<String> models = new ArrayList<String>(Arrays.asList(filenames));
        models.add("default");
        return SharedSuggestionProvider.m_82970_(models, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> NPC_MODELS = (context, builder) -> {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        models.add(new ResourceLocation("minecraft:player"));
        models.add(new ResourceLocation("minecraft:player_slim"));
        for (ResourceLocation location : Registry.f_122826_.m_6566_()) {
            if (location.toString().equals("cosmicnpcs:cosmic_npc") || !(((EntityType)Registry.f_122826_.m_7745_(location)).m_20615_((Level)((CommandSourceStack)context.getSource()).m_81372_()) instanceof LivingEntity)) continue;
            models.add(location);
        }
        return SharedSuggestionProvider.m_82926_(models, (SuggestionsBuilder)builder);
    };

    public static ArrayList<File> getAllFiles(ArrayList<File> fileList, File mainFolder) {
        File[] files;
        for (File file : files = mainFolder.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            SuggestionProviders.getAllFiles(fileList, file);
        }
        return fileList;
    }
}

