/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CEnergyLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final CreeperModel<Creeper> creeperModel;
    private final WitherBossModel<WitherBoss> witherModel;
    private Type type;
    private boolean isCharged;
    private String layerTexture;

    public CEnergyLayer(RenderLayerParent<T, M> p_i50947_1_, EntityModelSet modelSet, CosmicNPCEntity npc, Type type) {
        super(p_i50947_1_);
        this.creeperModel = new CreeperModel(modelSet.m_171103_(ModelLayers.f_171129_));
        this.witherModel = new WitherBossModel(modelSet.m_171103_(ModelLayers.f_171215_));
        this.type = type;
        this.isCharged = npc.getSettings().m_128471_("Charged");
        this.layerTexture = npc.getSettings().m_128461_("Layer");
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.isCharged) {
            float f = (float)((LivingEntity)entitylivingbaseIn).f_19797_ + partialTicks;
            EntityModel<T> entitymodel = this.model();
            entitymodel.m_6839_(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.m_117386_().m_102624_(entitymodel);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)this.getLayerTexture(), (float)this.xOffset(f), (float)(f * 0.01f)));
            entitymodel.m_6973_(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            entitymodel.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected float xOffset(float p_225634_1_) {
        if (this.type == Type.WITHER) {
            return Mth.m_14089_((float)(p_225634_1_ * 0.02f)) * 3.0f;
        }
        return p_225634_1_ * 0.01f;
    }

    protected EntityModel<T> model() {
        if (this.type == Type.WITHER) {
            return this.witherModel;
        }
        return this.creeperModel;
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return this.type.getResourceLocation();
    }

    public static enum Type {
        CREEPER(new ResourceLocation("textures/entity/creeper/creeper_armor.png")),
        WITHER(new ResourceLocation("textures/entity/wither/wither_armor.png"));

        private ResourceLocation resourceLocation;

        private Type(ResourceLocation loc) {
            this.resourceLocation = loc;
        }

        private ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

