/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CVillagerLevelPendantLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M>
implements ResourceManagerReloadListener {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), p_215348_0_ -> {
        p_215348_0_.put(1, (Object)new ResourceLocation("stone"));
        p_215348_0_.put(2, (Object)new ResourceLocation("iron"));
        p_215348_0_.put(3, (Object)new ResourceLocation("gold"));
        p_215348_0_.put(4, (Object)new ResourceLocation("emerald"));
        p_215348_0_.put(5, (Object)new ResourceLocation("diamond"));
    });
    private final Object2ObjectMap<VillagerType, VillagerMetaDataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetaDataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ReloadableResourceManager resourceManager;
    private final String path;
    private String villagerTypeTexture;
    private String professionTexture;
    private String professionLevelTexture;

    public CVillagerLevelPendantLayer(RenderLayerParent<T, M> p_i50955_1_, ReloadableResourceManager p_i50955_2_, String p_i50955_3_, CosmicNPCEntity npc) {
        super(p_i50955_1_);
        this.resourceManager = p_i50955_2_;
        this.path = p_i50955_3_;
        CompoundTag settings = npc.getSettings();
        this.villagerTypeTexture = settings.m_128461_("VillagerType");
        this.professionTexture = settings.m_128461_("Profession");
        this.professionLevelTexture = settings.m_128461_("ProfessionLevel");
        if (!settings.m_128461_("Layer").equals("default")) {
            this.villagerTypeTexture = settings.m_128461_("Layer");
        }
        p_i50955_2_.m_7217_((PreparableReloadListener)this);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.m_20145_()) {
            VillagerData villagerdata = ((VillagerDataHolder)entitylivingbaseIn).m_7141_();
            VillagerType villagertype = villagerdata.m_35560_();
            VillagerProfession villagerprofession = villagerdata.m_35571_();
            VillagerMetaDataSection.Hat villagermetadatasection$hattype = this.getHatData(this.typeHatCache, "type", Registry.f_122868_, villagertype);
            VillagerMetaDataSection.Hat villagermetadatasection$hattype1 = this.getHatData(this.professionHatCache, "profession", Registry.f_122869_, villagerprofession);
            EntityModel m = this.m_117386_();
            ((VillagerHeadModel)m).m_7491_(villagermetadatasection$hattype1 == VillagerMetaDataSection.Hat.NONE || villagermetadatasection$hattype1 == VillagerMetaDataSection.Hat.PARTIAL && villagermetadatasection$hattype != VillagerMetaDataSection.Hat.FULL);
            ResourceLocation resourcelocation = this.getVillagerTypeTexture(this.villagerTypeTexture, Registry.f_122868_.m_7981_((Object)villagertype));
            CVillagerLevelPendantLayer.m_117376_((EntityModel)m, (ResourceLocation)resourcelocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
            ((VillagerHeadModel)m).m_7491_(true);
            if (villagerprofession != VillagerProfession.f_35585_ && !entitylivingbaseIn.m_6162_()) {
                ResourceLocation resourcelocation1 = this.getProfessionTexture(this.professionTexture, Registry.f_122869_.m_7981_((Object)villagerprofession));
                CVillagerLevelPendantLayer.m_117376_((EntityModel)m, (ResourceLocation)resourcelocation1, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                if (villagerprofession != VillagerProfession.f_35596_) {
                    ResourceLocation resourcelocation2 = this.getProfessionLevelTexture(this.professionLevelTexture, (ResourceLocation)LEVEL_LOCATIONS.get(Mth.m_14045_((int)villagerdata.m_35576_(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    CVillagerLevelPendantLayer.m_117376_((EntityModel)m, (ResourceLocation)resourcelocation2, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(String p_215351_1_, ResourceLocation p_215351_2_) {
        return new ResourceLocation(p_215351_2_.m_135827_(), "textures/entity/" + this.path + "/" + p_215351_1_ + "/" + p_215351_2_.m_135815_() + ".png");
    }

    public <K> VillagerMetaDataSection.Hat getHatData(Object2ObjectMap<K, VillagerMetaDataSection.Hat> p_117659_, String p_117660_, DefaultedRegistry<K> p_117661_, K p_117662_) {
        return (VillagerMetaDataSection.Hat)p_117659_.computeIfAbsent(p_117662_, p_234880_ -> this.resourceManager.m_213713_(this.getResourceLocation(p_117660_, p_117661_.m_7981_(p_117662_))).flatMap(p_234875_ -> {
            try {
                return p_234875_.m_215509_().m_214059_((MetadataSectionSerializer)VillagerMetaDataSection.f_119065_).map(VillagerMetaDataSection::m_119070_);
            }
            catch (IOException ioexception) {
                return Optional.empty();
            }
        }).orElse(VillagerMetaDataSection.Hat.NONE));
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.professionHatCache.clear();
        this.typeHatCache.clear();
    }

    public ResourceLocation getVillagerTypeTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : Registry.f_122868_.m_6579_()) {
            if (!((VillagerType)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("type", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("type", loc);
    }

    public ResourceLocation getProfessionTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : Registry.f_122869_.m_6579_()) {
            if (!((VillagerProfession)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("profession", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession", loc);
    }

    public ResourceLocation getProfessionLevelTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession_level", loc);
    }
}

