/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.common.command.argument.CComponentArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntityArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class NPCModifyCommand {
    public NPCModifyCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modify-npc").requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)CEntityArgument.entity()).then(Commands.m_82127_((String)"settings").then(Commands.m_82129_((String)"settings", (ArgumentType)CompoundTagArgument.m_87657_()).executes(command -> this.modifySetting((CommandContext<CommandSourceStack>)command))))).then(Commands.m_82127_((String)"data").then(Commands.m_82129_((String)"replay-data", (ArgumentType)CompoundTagArgument.m_87657_()).executes(command -> this.modifyReplayData((CommandContext<CommandSourceStack>)command))))).then(Commands.m_82127_((String)"nbt").then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(command -> this.modifyNBT((CommandContext<CommandSourceStack>)command))))).then(Commands.m_82127_((String)"name").then(Commands.m_82129_((String)"name", (ArgumentType)CComponentArgument.textComponent()).executes(command -> this.modifyName((CommandContext<CommandSourceStack>)command))))).then(Commands.m_82127_((String)"texture").then(Commands.m_82129_((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(command -> this.modifyTexture((CommandContext<CommandSourceStack>)command))))).then(Commands.m_82127_((String)"model").then(Commands.m_82129_((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(command -> this.modifyModel((CommandContext<CommandSourceStack>)command))))));
    }

    public int modifyName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        Component name = CComponentArgument.getComponent(context, "name");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setNPCName(name);
            if (npc.m_8077_()) {
                npc.m_6593_(npc.getNPCName());
            }
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyTexture(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        String texture = StringArgumentType.getString(context, (String)"texture");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setTextureName(texture);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyModel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        ResourceLocation model = CEntitySummonArgument.getEntityId(context, "model");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setModel(model);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifySetting(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        CompoundTag newSettings = CompoundTagArgument.m_87660_(context, (String)"settings");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldSettings = npc.getSettings();
            oldSettings = oldSettings.m_128391_(newSettings);
            npc.setSettings(new CompoundTag());
            npc.setSettings(oldSettings);
            this.updateNPCSettings(npc);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyReplayData(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        CompoundTag newData = CompoundTagArgument.m_87660_(context, (String)"replay-data");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldData = npc.getReplayData();
            oldData = oldData.m_128391_(newData);
            npc.setReplayData(new CompoundTag());
            npc.setReplayData(oldData.m_128391_(newData));
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyNBT(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        CompoundTag newNbt = CompoundTagArgument.m_87660_(context, (String)"nbt");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldNbt = new CompoundTag();
            npc.m_7380_(oldNbt);
            CompoundTag tag = oldNbt.m_128391_(newNbt);
            npc.m_7378_(new CompoundTag());
            npc.m_7378_(tag);
            this.updateNPCSettings(npc);
        }
        this.sendFeedback(context);
        return 0;
    }

    private void sendFeedback(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        if (!(entity instanceof CosmicNPCEntity)) {
            Player player;
            if (entity instanceof Player && CosmicNPCs.instance.recordThreads.get(player = (Player)entity) != null) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"NPC-Data was modified"), false);
                return;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Command can only be used on NPCs"));
            return;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"NPC-Data was modified"), false);
    }

    private void updateNPCSettings(CosmicNPCEntity npc) {
        if (npc.getSettings().m_128451_("ShowNameTag") >= 1) {
            npc.m_6593_(npc.getNPCName());
        } else {
            npc.m_6593_(null);
        }
        if (npc.getSettings().m_128451_("ShowNameTag") == 1) {
            npc.m_20340_(true);
        } else {
            npc.m_20340_(false);
        }
        npc.m_20331_(npc.getSettings().m_128471_("Invulnerable"));
        npc.m_21051_(Attributes.f_22276_).m_22100_(npc.getSettings().m_128459_("Health"));
        if (npc.m_21233_() > npc.m_21223_()) {
            npc.m_21153_(npc.m_21233_());
        }
    }
}

