/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class CEntitySummonArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:pig", "cow");
    public static final DynamicCommandExceptionType ENTITY_UNKNOWN_TYPE = new DynamicCommandExceptionType(p_211367_0_ -> Component.m_237110_((String)"entity.notFound", (Object[])new Object[]{p_211367_0_}));

    public static CEntitySummonArgument entitySummon() {
        return new CEntitySummonArgument();
    }

    public static ResourceLocation getEntityId(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return CEntitySummonArgument.checkIfEntityExists((ResourceLocation)context.getArgument(name, ResourceLocation.class));
    }

    private static ResourceLocation checkIfEntityExists(ResourceLocation id) throws CommandSyntaxException {
        if (!id.equals((Object)new ResourceLocation("minecraft:player")) && !id.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            Registry.f_122826_.m_6612_(id).filter(EntityType::m_20654_).orElseThrow(() -> ENTITY_UNKNOWN_TYPE.create((Object)id));
        }
        return id;
    }

    public ResourceLocation parse(StringReader p_parse_1_) throws CommandSyntaxException {
        return CEntitySummonArgument.checkIfEntityExists(ResourceLocation.m_135818_((StringReader)p_parse_1_));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

