/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CStrayClothingLayer<T extends Mob, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation STRAY_CLOTHES_TEXTURES = new ResourceLocation("textures/entity/skeleton/stray_overlay.png");
    private final SkeletonModel<T> layerModel;
    private String layerTexture;

    public CStrayClothingLayer(RenderLayerParent<T, M> p_i50919_1_, EntityModelSet modelSet, CosmicNPCEntity npc) {
        super(p_i50919_1_);
        this.layerModel = new SkeletonModel(modelSet.m_171103_(ModelLayers.f_171250_));
        this.layerTexture = npc.getSettings().m_128461_("Layer");
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CStrayClothingLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)this.getLayerTexture(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return STRAY_CLOTHES_TEXTURES;
    }
}

