/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import com.google.gson.Gson;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.common.events.TickEvents;
import de.namensammler.cosmicnpcs.core.CCAPData;
import de.namensammler.cosmicnpcs.core.CCAPJson;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.storage.LevelResource;

public class PlayTickThread {
    public CCAPData ccapData;
    CosmicNPCEntity replayEntity;
    public RandomAccessFile in;
    String recFile;
    boolean loop;
    public double ticks;

    public PlayTickThread(@Nullable CosmicNPCEntity cosmicNPCEntity, String recfile) {
        this(cosmicNPCEntity.f_19853_, recfile);
        this.replayEntity = cosmicNPCEntity;
        this.replayEntity.ccapJson = this.readJson(cosmicNPCEntity.f_19853_);
    }

    public PlayTickThread(Level level, String recfile) {
        try {
            this.in = new RandomAccessFile(PlayTickThread.getRecFile(level, recfile), "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.ccapData = new CCAPData();
        this.replayEntity = null;
        this.recFile = recfile;
        this.checkCompatibility();
    }

    public PlayTickThread fromBeginning() {
        if (this.replayEntity == null) {
            return this;
        }
        this.replayEntity.getReplayData().m_128405_("TimelinePos", 0);
        return this;
    }

    public void checkCompatibility() {
        try {
            short magic = this.in.readShort();
            int compatibility = PlayTickThread.getCompatibility(magic);
            switch (compatibility) {
                case 1: {
                    break;
                }
                case 0: {
                    this.ccapData.hasEnded = true;
                    throw new Exception("The ccap file is not compatible with this mod version. (" + magic + ")");
                }
                default: {
                    this.ccapData.hasEnded = true;
                    throw new Exception("Not an ccap file.");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Replay thread interrupted");
            this.ccapData.hasEnded = true;
            e.printStackTrace();
        }
    }

    public static int getCompatibility(short magic) {
        switch (magic) {
            case -5120: {
                return 0;
            }
            case -5119: {
                return 1;
            }
        }
        return -1;
    }

    public void tick() {
        if (this.replayEntity == null) {
            return;
        }
        int timePos = this.replayEntity.getReplayData().m_128451_("TimelinePos");
        if (timePos != (int)this.ticks && timePos >= 0) {
            try {
                this.ticks = 0.0;
                this.in.seek(2L);
                this.readRecFile(timePos * 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.readRecFile(1);
        this.applyCurrentData();
        this.replayEntity.getReplayData().m_128405_("TimelinePos", (int)this.ticks);
        this.loop = this.replayEntity.getSettings().m_128471_("Loop");
        if (this.replayEntity.m_213877_()) {
            this.ccapData.hasEnded = true;
            this.loop = false;
        }
        if (this.ccapData.hasEnded) {
            if (!this.loop) {
                if (!this.replayEntity.getSettings().m_128471_("ShouldPersist") && this.replayEntity.getReplayData().m_128461_("NextReplay").equals("")) {
                    this.replayEntity.m_146870_();
                    return;
                }
                this.replayEntity.getReplayData().m_128359_("CurrentReplay", "");
            }
            this.fromBeginning();
            this.replayEntity.isReplayActive = false;
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        String currentReplay = this.replayEntity.getReplayData().m_128461_("CurrentReplay");
        if (!this.recFile.equals(currentReplay) && PlayTickThread.doesRecFileExist(this.replayEntity.m_9236_(), currentReplay)) {
            this.replayEntity.isReplayActive = false;
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ccapData.hasEnded = true;
        }
    }

    public void readRecFile(int iterations) {
        for (int i = 0; i < iterations; ++i) {
            try {
                this.ccapData.yHeadRot = this.in.readFloat();
                this.ccapData.yRot = this.in.readFloat();
                this.ccapData.xRot = this.in.readFloat();
                this.ccapData.x = this.in.readDouble();
                this.ccapData.y = this.in.readDouble();
                this.ccapData.z = this.in.readDouble();
                this.ccapData.deltaX = this.in.readDouble();
                this.ccapData.deltaY = this.in.readDouble();
                this.ccapData.deltaZ = this.in.readDouble();
                this.ccapData.fallDistance = this.in.readFloat();
                this.ccapData.hasImpulse = this.in.readBoolean();
                this.ccapData.isSneaking = this.in.readBoolean();
                this.ccapData.isSprinting = this.in.readBoolean();
                this.ccapData.isOnGround = this.in.readBoolean();
                this.ccapData.isElytraFlying = this.in.readBoolean();
                this.ccapData.isSwimming = this.in.readBoolean();
                this.ccapData.isHandActive = this.in.readBoolean();
                this.ccapData.handType = InteractionHand.values()[this.in.readInt()];
                this.ccapData.hasAction = this.in.readBoolean();
                if (this.ccapData.hasAction) {
                    byte type = this.in.readByte();
                    NPCAction ma = new NPCAction(type);
                    switch (type) {
                        case 1: {
                            ma.message = this.in.readUTF();
                            break;
                        }
                        case 4: {
                            int aSlot = this.in.readInt();
                            int aId = this.in.readInt();
                            int aDmg = this.in.readInt();
                            if (aId != -1) {
                                ma.itemData = NbtIo.m_128928_((DataInput)this.in);
                            }
                            ma.armorSlot = aSlot;
                            ma.armorId = aId;
                            ma.armorDmg = aDmg;
                            break;
                        }
                        case 3: {
                            ma.itemData = NbtIo.m_128928_((DataInput)this.in);
                            break;
                        }
                        case 5: {
                            ma.arrowCharge = this.in.readInt();
                            break;
                        }
                        case 8: {
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            break;
                        }
                        case 7: {
                            ma.stateId = this.in.readInt();
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            if (!(Block.m_49803_((int)ma.stateId).m_60734_() instanceof SignBlock)) break;
                            ma.itemData = NbtIo.m_128928_((DataInput)this.in);
                            break;
                        }
                        case 9: {
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            ma.metaData = this.in.readInt();
                            break;
                        }
                        case 11: {
                            ma.handType = InteractionHand.values()[this.in.readByte()];
                            break;
                        }
                        case 14: {
                            ma.message = this.in.readUTF();
                        }
                    }
                    ma.timeStamp = (int)this.ticks;
                    this.ccapData.recentAction = ma;
                    this.ccapData.actionList.add(ma);
                }
            }
            catch (EOFException e) {
                this.ccapData.hasEnded = true;
                break;
            }
            catch (Exception e) {
                this.ccapData.hasEnded = true;
                System.out.println("Replay thread interrupted");
                e.printStackTrace();
            }
            this.ticks += 0.5;
        }
    }

    public void applyCurrentData() {
        if (this.replayEntity == null) {
            return;
        }
        this.replayEntity.f_19812_ = this.ccapData.hasImpulse;
        this.replayEntity.m_20334_(this.ccapData.deltaX, this.ccapData.deltaY, this.ccapData.deltaZ);
        this.replayEntity.f_19789_ = this.ccapData.fallDistance;
        this.replayEntity.m_20260_(this.ccapData.isSneaking);
        this.replayEntity.m_6858_(this.ccapData.isSprinting);
        this.replayEntity.m_6853_(this.ccapData.isOnGround);
        this.replayEntity.setElytraFlying(this.ccapData.isElytraFlying);
        this.replayEntity.m_19890_(this.ccapData.x, this.ccapData.y, this.ccapData.z, this.ccapData.yRot, this.ccapData.xRot);
        this.replayEntity.m_5616_(this.ccapData.yHeadRot);
        if (this.ccapData.isHandActive.booleanValue()) {
            this.replayEntity.m_6672_(this.ccapData.handType);
        } else {
            this.replayEntity.m_5810_();
        }
        if (this.ccapData.hasAction) {
            boolean flag = true;
            if (this.replayEntity.ccapJson.overwrite && (this.ccapData.recentAction.type == 1 || this.ccapData.recentAction.type == 14)) {
                flag = false;
            }
            if (flag) {
                this.replayEntity.eventsList.add(this.ccapData.recentAction);
            }
        }
        if (this.replayEntity.ccapJson.overwrite) {
            NPCAction ma;
            for (CCAPJson.Message msg : this.replayEntity.ccapJson.chatMessages) {
                if (this.ticks != (double)msg.timestamp) continue;
                ma = new NPCAction(1);
                ma.message = msg.message;
                this.replayEntity.eventsList.add(ma);
            }
            for (CCAPJson.Message msg : this.replayEntity.ccapJson.commands) {
                if (this.ticks != (double)msg.timestamp) continue;
                ma = new NPCAction(14);
                ma.message = msg.message;
                this.replayEntity.eventsList.add(ma);
            }
        }
        if (this.ccapData.hasEnded) {
            this.replayEntity.getReplayData().m_128405_("ReplaysCompleted", this.replayEntity.getReplayData().m_128451_("ReplaysCompleted") + 1);
        }
    }

    public static boolean doesRecFileExist(Level level, String filename) {
        return PlayTickThread.getRecFile(level, filename).exists();
    }

    public static File getRecFile(Level level, String filename) {
        Path path = level.m_7654_().m_129843_(new LevelResource("cosmicnpcs/recordings"));
        File file = path.resolve(filename + ".ccap").toFile();
        return file;
    }

    public CCAPJson readJson(Level level) {
        CCAPJson ccapJson = null;
        String filePath = PlayTickThread.getRecFile(level, this.recFile).getPath().concat(".json");
        File file = new File(filePath);
        if (!file.exists()) {
            return new CCAPJson();
        }
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            Gson gson = new Gson();
            ccapJson = (CCAPJson)gson.fromJson((Reader)reader, CCAPJson.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ccapJson != null ? ccapJson : new CCAPJson();
    }

    public static void register(PlayTickThread player) {
        TickEvents.playTickThreads.add(player);
    }
}

