/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class CEntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_ENTITY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.entity.toomany"));
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.player.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_PLAYERS_ALLOWED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.player.entities"));
    public static final SimpleCommandExceptionType ERROR_ONLY_NPCS_ALLOWED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.npcs.entities"));
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.entity.selector.not_allowed"));
    private static final byte FLAG_SINGLE = 1;
    private static final byte FLAG_PLAYERS_ONLY = 2;
    final boolean single;
    final boolean playersOnly;

    protected CEntityArgument(boolean p_91447_, boolean p_91448_) {
        this.single = p_91447_;
        this.playersOnly = p_91448_;
    }

    public static CEntityArgument entity() {
        return new CEntityArgument(true, false);
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> p_91453_, String p_91454_) throws CommandSyntaxException {
        return ((EntitySelector)p_91453_.getArgument(p_91454_, EntitySelector.class)).m_121139_((CommandSourceStack)p_91453_.getSource());
    }

    public static CEntityArgument entities() {
        return new CEntityArgument(false, false);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> p_91462_, String p_91463_) throws CommandSyntaxException {
        Collection<? extends Entity> collection = CEntityArgument.getOptionalEntities(p_91462_, p_91463_);
        if (collection.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> getOptionalEntities(CommandContext<CommandSourceStack> p_91468_, String p_91469_) throws CommandSyntaxException {
        return ((EntitySelector)p_91468_.getArgument(p_91469_, EntitySelector.class)).m_121160_((CommandSourceStack)p_91468_.getSource());
    }

    public static Collection<ServerPlayer> getOptionalPlayers(CommandContext<CommandSourceStack> p_91472_, String p_91473_) throws CommandSyntaxException {
        return ((EntitySelector)p_91472_.getArgument(p_91473_, EntitySelector.class)).m_121166_((CommandSourceStack)p_91472_.getSource());
    }

    public static CEntityArgument player() {
        return new CEntityArgument(true, true);
    }

    public static ServerPlayer getPlayer(CommandContext<CommandSourceStack> p_91475_, String p_91476_) throws CommandSyntaxException {
        return ((EntitySelector)p_91475_.getArgument(p_91476_, EntitySelector.class)).m_121163_((CommandSourceStack)p_91475_.getSource());
    }

    public static CEntityArgument players() {
        return new CEntityArgument(false, true);
    }

    public static Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> p_91478_, String p_91479_) throws CommandSyntaxException {
        List list = ((EntitySelector)p_91478_.getArgument(p_91479_, EntitySelector.class)).m_121166_((CommandSourceStack)p_91478_.getSource());
        if (list.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        return list;
    }

    public EntitySelector parse(StringReader p_91451_) throws CommandSyntaxException {
        boolean i = false;
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_91451_);
        entityselectorparser.m_121241_((EntityType)EntityTypesInit.COSMIC_NPC.get());
        EntitySelector entityselector = entityselectorparser.m_121377_();
        if (entityselector.m_121138_() > 1 && this.single) {
            if (this.playersOnly) {
                p_91451_.setCursor(0);
                throw ERROR_NOT_SINGLE_PLAYER.createWithContext((ImmutableStringReader)p_91451_);
            }
            p_91451_.setCursor(0);
            throw ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)p_91451_);
        }
        if (!entityselector.m_121159_()) {
            p_91451_.setCursor(0);
            throw ERROR_ONLY_NPCS_ALLOWED.createWithContext((ImmutableStringReader)p_91451_);
        }
        return entityselector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_91482_, SuggestionsBuilder p_91483_) {
        if (p_91482_.getSource() instanceof SharedSuggestionProvider) {
            StringReader stringreader = new StringReader(p_91483_.getInput());
            stringreader.setCursor(p_91483_.getStart());
            SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)p_91482_.getSource();
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader, sharedsuggestionprovider.m_6761_(2));
            try {
                entityselectorparser.m_121377_();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entityselectorparser.m_121249_(p_91483_, p_91457_ -> {
                Collection collection = sharedsuggestionprovider.m_5982_();
                Collection iterable = this.playersOnly ? collection : Iterables.concat((Iterable)collection, (Iterable)sharedsuggestionprovider.m_6264_());
                SharedSuggestionProvider.m_82970_((Iterable)iterable, (SuggestionsBuilder)p_91457_);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info
    implements ArgumentTypeInfo<CEntityArgument, Template> {
        private static final byte FLAG_SINGLE = 1;
        private static final byte FLAG_PLAYERS_ONLY = 2;

        public void serializeToNetwork(Template p_231271_, FriendlyByteBuf p_231272_) {
            int i = 0;
            if (p_231271_.single) {
                i |= 1;
            }
            if (p_231271_.playersOnly) {
                i |= 2;
            }
            p_231272_.writeByte(i);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf p_231282_) {
            byte b0 = p_231282_.readByte();
            return new Template((b0 & 1) != 0, (b0 & 2) != 0);
        }

        public void serializeToJson(Template p_231268_, JsonObject p_231269_) {
            p_231269_.addProperty("amount", p_231268_.single ? "single" : "multiple");
            p_231269_.addProperty("type", p_231268_.playersOnly ? "players" : "entities");
        }

        public Template unpack(CEntityArgument p_231274_) {
            return new Template(p_231274_.single, p_231274_.playersOnly);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<CEntityArgument> {
            final boolean single;
            final boolean playersOnly;

            Template(boolean p_231290_, boolean p_231291_) {
                this.single = p_231290_;
                this.playersOnly = p_231291_;
            }

            public CEntityArgument instantiate(CommandBuildContext p_231294_) {
                return new CEntityArgument(this.single, this.playersOnly);
            }

            public ArgumentTypeInfo<CEntityArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

